/*$Id: $*/

function searchTreeNode(searchText){
	return searchTreeRecursive(searchText.toLowerCase(),TREE_NODES,'');
}

function searchTreeRecursive(searchText,arr,parent){
	var ret = [];
	var lastReadObj = parent;
	for(var i=0;i<arr.length;i++){
		var obj = arr[i];
		if(obj instanceof Array){
			ret = ret.concat(searchTreeRecursive(searchText,obj,lastReadObj+' - '));
		}else{
			lastReadObj = parent + obj;
			if(obj.toLowerCase().indexOf(searchText)>-1){
				ret.push({name:parent.substring(2) + arr[i],url:arr[i+1]});
			}
			i += 2;
		}
	}
	return ret;
}

$TREE_NODES = [
	['Welcome to ADAudit Plus', "welcome/welcome-to-ad-audit-plus.html", "MAIN",
		['Release Notes',"welcome/release-notes.html", "MAIN",
		],
		['Contact ZOHO Corp.',"welcome/contact-zohocorp.html", "MAIN",
		],
	],
	['ADAudit Plus Terminologies', "ad-terminologies/ad-audit-plus-terminologies.html", "MAIN",
	],
	['Getting Started', "getting-started/getting-started.html", "MAIN",
		['System Requirements', "getting-started/system-requirements.html", "MAIN",
		],
		['Installing ADAudit Plus', "getting-started/installing-ad-audit-plus.html", "MAIN",
		],
		['Working with ADAudit Plus', "getting-started/working-with-ad-audit-plus.html", "MAIN",
		],
		['Licensing ADAudit Plus', "getting-started/licensing-ad-audit-plus.html", "MAIN",
		],
        ['Privileges required to collect audit data', "getting-started/audit-permissions-configuration-ad-audit-plus.html", "MAIN",
		],
		['Configuring Audit Policy', "getting-started/configure-policy.html", "MAIN",
			['For Domain Controllers', "getting-started/domain-controllers-auditing.html", "MAIN",
				['Automatic Configuration', "getting-started/automatic-configuration-dc-auditing.html", "MAIN",
				],
				['Manual Configuration', "getting-started/manual-configuration-dc-auditing-page.html", "MAIN",
					['Configuring Audit Policies for Active Directory Auditing', "getting-started/manual-configuration-dc-auditing.html", "MAIN",
					],
					['Configuring SACLs for Active Directory Auditing', "reports/access-aduc-to-enable-audit-sacls.html", "MAIN",
					],
				],
			],
			['For File Servers', "getting-started/file-server-audit-policy.html", "MAIN",
				['Automatic Configuration', "getting-started/auto-configuration-object-access-auditing.html", "MAIN",
				],
				['Manual Configuration', "getting-started/manual-configuration-fs-auditing.html", "MAIN",
					['Configuring Audit Policies for File Server Auditing', "getting-started/configure-object-access-auditing.html", "MAIN",
					],
					['Configuring SACLs for File Auditing', "getting-started/sacls-to-audit-files-and-shares.html", "MAIN",
					],
				],
			],
			['For Member Servers', "getting-started/member-server-audit-policy.html", "MAIN",
				['Automatic Configuration', "getting-started/auto-configuration-ms-auditing.html", "MAIN",
				],
				['Manual Configuration', "getting-started/manual-configuration-ms-auditing.html", "MAIN",
					['Configuring Audit Policies for Member Server Auditing', "getting-started/configure-policy-member-server-auditing.html", "MAIN",
					],
				],
			],
			['For Workstations', "getting-started/workstations-audit-policy.html", "MAIN",
				['Automatic Configuration', "getting-started/auto-configuration-workstation-auditing.html", "MAIN",
				],
				['Manual Configuration', "getting-started/manual-configuration-workstation-auditing.html", "MAIN",
					['Configuring Audit Policies for Workstation Auditing', "getting-started/configure-audit-logon-workstation-auditing.html", "MAIN",
					],
				],
			],
			['For NetApp Filers', "getting-started/netappfiler.html", "MAIN",
				['Automatic Configuration', "getting-started/netapp-filer-auto-configuration.html", "MAIN",
				],
				['Manual Configuration', "getting-started/netapp-filer-manual-configuration-page.html", "MAIN",
                    ['Configuring Audit Policies for NetApp Filer Auditing', "getting-started/netapp-filer-manual-configuration.html", "MAIN",
					],
					['Configuring SACLs for NetApp Filers Auditing', "getting-started/sacls-to-audit-files-and-shares.html", "MAIN",
					],
				],
			],
			['For NetApp Cluster Filers', "getting-started/netapp-cluster.html", "MAIN",
				['Automatic Configuration', "getting-started/netapp-cluster-auto-configuration.html", "MAIN",
				],
				['Manual Configuration', "getting-started/netapp-cluster-manual-configuration-page.html", "MAIN",
                    ['Configuring Audit Policies for NetApp Cluster Auditing', "getting-started/netapp-cluster-manual-configuration.html", "MAIN",
					],
					['Configuring SACLs for NetApp Cluster', "getting-started/sacls-to-audit-files-and-shares.html", "MAIN",
					],
				],
			],
			['For EMC Storage', "getting-started/emc-server-audit-policy.html", "MAIN",
				['Automatic Configuration', "getting-started/emc-server-auto-configuration.html", "MAIN",
				],
				['Manual Configuration', "getting-started/emc-server-manual-configuration-page.html", "MAIN",
					['Configuring Audit Policies for EMC', "getting-started/emc-server-manual-configuration.html", "MAIN",
					],
					['Configuring Event Log Settings for EMC', "getting-started/emc-sever-event-log-settings.html", "MAIN",
					],
                    ['Configuring SACLs for EMC Stroage', "getting-started/sacls-to-audit-files-and-shares.html", "MAIN",
					],
				],
			],
            ['For EMC Isilon Storage', "getting-started/emc-isilon-audit-settings.html", "MAIN"],
			['For File Integrity Monitoring', "getting-started/fim-audit-policy.html", "MAIN",
				
					['Configuring FIM in ADAudit Plus', "getting-started/file-integrity-monitoring.html", "MAIN",
					],
					['Configuring Audit Policy', "getting-started/configuring-fim-audit-policy.html", "MAIN",
					],
					['Configuring SACLs For File Integrity', "getting-started/sacls-to-audit-fim.html", "MAIN",
					],
			],
		],
		['Security Log Size and Retention Settings', "getting-started/event-log-size-retention-settings.html", "MAIN",
		],
		['Configuring Account Lockout Analyzer', "getting-started/configuring-account-lockout-analyzer.html", "MAIN",
			['Automatic Configuration', "getting-started/automatic-configuration-of-account-analyzer.html", "MAIN",
			],
			['Manual Configuration', "getting-started/manual-configuration-of-account-lockout-analyzer.html", "MAIN",
			],
		],
        ['Configuring ADFS Audit Settings', "getting-started/configuration-adfs-auditing.html", "MAIN",
			['Manual Configuration', "getting-started/manual-config-adfs-auditing.html", "MAIN",
			],
		],
		[
            'Migrating to MSSQL Server', "getting-started/configure-mssql-ad-audit-plus.html", "MAIN",
			
        ],
		['SIEM Integration', "getting-started/siem-integration.html", "MAIN",
		]
	],
	['Dashboard View', "getting-started/dashboard-view.html", "MAIN",
	],
	['Reports', "reports/reports.html", "MAIN",
		['User Logon Reports', "reports/user-logon-reports.html", "MAIN",
		],
		['Local Logon Logoff Reports', "reports/local-logon-logoff-reports.html", "MAIN",
			['Radius Logon - Network Policy Server', "reports/radius-logon-audit-reports.html", "MAIN",
			],
		],
		['Account Management', "reports/account-management-reports.html", "MAIN",
		],
		['User Management', "reports/user-management.html", "MAIN",
		],
		['Group Management', "reports/group-management.html", "MAIN",
		],
		['Computer Management', "reports/computer-management.html", "MAIN",
		],
		['OU Management Audit Reports', "reports/ou-management-audit-reports.html", "MAIN",
		],
		['GPO Management Audit Reports', "reports/gpo-management-audit-reports.html", "MAIN",
		],
		['Advanced GPO Reports', "reports/advanced-gpo-audit-reports.html", "MAIN",
		],
		['Other AD Object Changes', "reports/other-ad-object-changes-reports.html", "MAIN",
		],
		['Configuration Auditing', "reports/ad-configuration-audit-reports.html", "MAIN",
		],
		['Permission Changes', "reports/ad-permission-changes-reports.html", "MAIN",
		],
		['DNS Changes', "reports/ad-dns-changes-reports.html", "MAIN",
		],
		['Removable Storage Audit', "reports/removable-usb-changes-audit-reports.html", "MAIN",
		],
		['Domain Policy Changes', "reports/domain-policy-changes.html", "MAIN",
		],
		['Server Audit Reports', "reports/server-audit-reports.html", "MAIN",
		],
		['Printer Audit Reports', "reports/printer-audit-reports.html", "MAIN",
		],
		['Profile Based Reports', "reports/profile-based-reports.html", "MAIN",
		],
		['Schedule Reports', "reports/schedule-reports.html", "MAIN",
		]
	],
	['File Audit', "fileaudit/file-audit.html", "MAIN",
		['Configuring File Servers', "getting-started/file-server-types-configuration.html", "MAIN",
		],
		['Windows File Audit Reports', "fileaudit/file-audit-reports.html", "MAIN",
		],
		['File Server based Reports', "fileaudit/server-based-file-audit-reports.html", "MAIN",
		],
		['User based File Audit Reports', "fileaudit/user-based-file-audit-reports.html", "MAIN",
		],
		['Share based File Audit Reports', "fileaudit/share-based-file-audit-reports.html", "MAIN",
		],
		['File Audit Report Profile', "fileaudit/file-audit-report-profiles.html", "MAIN",
		],
		['Profile based File Audit Reports', "fileaudit/profile-based-file-audit-reports.html", "MAIN",
		],
		['My Reports', "fileaudit/myreports.html", "MAIN",
		],
		['Advanced Configuration File Server Audit', "fileaudit/advanced-configuration-file-server-audit.html", "MAIN",
		],
		['Exclude Configuration(File Server Audit)', "fileaudit/exclude-files-file-server-audit.html", "MAIN",
		]
	],
	['Alerts', "alerts/alerts.html", "MAIN",
	],
	['Configuration', "configuration/configuration.html", "MAIN",
		['Configure Member Servers', "configuration/member-servers.html", "MAIN",
		],
		['Configure Cloud Directory', "configuration/cloud-directory.html", "MAIN",
  		],
		['Report Profiles', "configuration/report-profile-categories.html", "MAIN",
		],
		['Alert Profiles', "configuration/alert-profiles.html", "MAIN",
		],
		['Audit Actions', "configuration/audit-actions.html", "MAIN",
		],
		['Advanced Configurations', "configuration/advanced-configurations.html", "MAIN",
		]
	],
	['Admin', "admin/admin.html", "MAIN",
		['Administration', "admin/domain-settings/administration.html", "MAIN",
			['Alert Me', "admin/general-settings/alert-me.html", "MAIN",
			],
			['Domain Settings', "admin/domain-settings/configuring-domains-and-domain-controllers.html", "MAIN",
			],
			['Technician Settings', "admin/general-settings/technician-audit-reports-view.html", "MAIN",
			],
			['Schedule Reports', "reports/schedule-reports.html", "MAIN",
			],
			['Disk Space Alert', "admin/general-settings/disk-space-alert.html", "MAIN",
			],
			['Exclude User Accounts', "admin/general-settings/exclude-user-accounts.html", "MAIN",
			],
			['Business Hours', "admin/general-settings/business-hours.html", "MAIN",
			],
		],
		['Admin Configuration', "admin/configuration/admin-configuration.html", "MAIN",
			['Alerts', "admin/domain-settings/manage-alerts.html", "MAIN",
			],
			['Archive Events', "admin/domain-settings/archive-settings.html", "MAIN",
			],
			['Restore Archived Events', "admin/domain-settings/restore-archived-events.html", "MAIN",
			],
			['Search Archived Events', "admin/domain-settings/archive-search.html", "MAIN",
			]
		],
		['General Settings', "admin/general-settings/general-settings.html", "MAIN",
			['Personalize', "admin/general-settings/personalize.html", "MAIN",
			],
			['Connection', "admin/general-settings/connection.html", "MAIN",
			],
			['ADAP Server', "admin/general-settings/server.html", "MAIN",
			],
			['Mail Server', "admin/general-settings/mail-server-settings.html", "MAIN",
			],
			['Jump To', "admin/general-settings/jump-to-settings.html", "MAIN",
			]
		],
	],
	['Troubleshooting Tips', "troubleshooting/troubleshooting.html", "MAIN",
	],
	['Known Issues and Limitations', "troubleshooting/known-issues.html", "MAIN",
	],
];
