/* $Id$ */
//ignorei18n_start

function changeColor(_this, event) {
	$('.filenode').css('color', '#000');
	let target = event.target || event.srcElement;
	$(target).css('color', '#2789B1');
	if(localStorage){
		localStorage.setItem('adap-tree-id',event.target.id);
	}
}

function showHide(_this, event) {
	let target = event.target || event.srcElement;
	let clickedObj = $("#" + target.nextSibling.id);
	let isClosed = clickedObj.hasClass('hide');
	if (isClosed) {
		$('.pagesList').not('.pagesList.hide').each(function(){toggleHide($(this));});
		toggleHide(clickedObj);
		clickedObj.parents().filter('.pagesList').each(function(){toggleHide($(this));});
	} else {
		toggleHide(clickedObj);
		clickedObj.children().children('.pagesList').each(function(){toggleHide($(this));});
	}
}

function toggleHide(element) {
	element.toggleClass('hide');
	element.prev().find('span').toggleClass('imagePlus').toggleClass('imageMinus');
}

$(document).ready(function () {
	let url = window.location.origin + window.location.pathname;
	let filename = url.split('/').pop();
	let isIndex = false;
	if (!filename || filename === "index.html")
	{
		isIndex = true;
		filename = "index.html";
	}
	let prefixForUrl = getPrefixFromUrl(url, isIndex);
	let prevNextHandler = {
		pre: "",
		nxt: ""
	};
	insertLhsContent(filename, prefixForUrl, isIndex, prevNextHandler);
	modifyLhsAndBred();
	insertPrevNext(prefixForUrl, isIndex, prevNextHandler);

	changeMarginTop(); // on page load
	addContextSetId();
});

// dynamically change margin based on size of bred-crumb
window.addEventListener('resize', changeMarginTop, false);

function addContextSetId(){
$('#lhsElement  a').on('contextmenu',function(event){
	if(localStorage){
		localStorage.setItem('adap-tree-id',event.target.id);
	}
})
}
function changeMarginTop() {
	let bredHeight = $(".bred").outerHeight();
	$(".lhs").css("margin-top", bredHeight);
	$("#leftmain").css("padding-bottom", 30 + bredHeight);
	$(".rhs").css("margin-top", bredHeight);
	$(".pg-nav").css("padding-bottom", 30 + bredHeight);
}

function insertLhsContent(filename, prefixForUrl, isIndex, prevNextHandler) {
	let idNum = [13000];
	let customLhs = document.createElement("ul");
	customLhs.setAttribute("id", "lhsElement");
	iterateLhsValues(filename, prefixForUrl, isIndex, idNum, Menus, customLhs, prevNextHandler);
	let htmlElement = document.getElementById("content");
	htmlElement.prepend(customLhs);
}

function iterateLhsValues(filename, prefixForUrl, isIndex, idNum, Menus, customLhs, prevNextHandler) {
	if (Array.isArray(Menus)) {
		for (let i = 0; i < Menus.length; i++) {
			iterateLhsValues(filename, prefixForUrl, isIndex, idNum, Menus[i], customLhs, prevNextHandler);
		}
	} else {
		let menuLink = Menus["MenuLink"];
		let menuName = Menus["MenuName"];
		let listElement = document.createElement("li");
		if (menuLink == "" && menuLink.length == 0) {
			let aElement = createAnchorForLhs("imagePlus plusminusicon", "return showHide(this, event)", "javascript: void(0)", menuName, idNum, undefined, undefined);
			let ulElement = document.createElement("ul");
			ulElement.className = "pagesList hide";
			ulElement.setAttribute('id', ++idNum[0]);
			listElement.appendChild(aElement);
			listElement.appendChild(ulElement);
			customLhs.appendChild(listElement);
			iterateLhsValues(filename, prefixForUrl, isIndex, idNum, Menus["Menus"], ulElement, prevNextHandler);
		} else {
			menuLink = prefixForUrl + menuLink;
			let classVal = handleNextPrevLinks(menuLink, menuLink.split('/').pop() == filename, isIndex, prevNextHandler);
			let aElement = createAnchorForLhs("imageMinus", "changeColor(this,event)", menuLink, menuName, idNum, classVal, "_self");
			listElement.appendChild(aElement);
			customLhs.appendChild(listElement);
		}
	}
}

function createAnchorForLhs(spanClass, onClickVal, hrefVal, innerVal, idNum, classVal, targetVal) {
	let spanElement = document.createElement('span');
	spanElement.setAttribute('class', spanClass);
	let aElement = document.createElement("a");
	aElement.setAttribute('onclick', onClickVal);
	aElement.setAttribute('href', hrefVal);
	aElement.setAttribute('id', ++idNum[0]);
	if (classVal != undefined) {
		aElement.setAttribute('class', classVal);
		aElement.setAttribute('target', targetVal);
	}
	aElement.innerHTML = (spanElement.outerHTML + innerVal);
	return aElement;
}

function handleNextPrevLinks(menuLink, isMenuIncludeFile, isIndex, prevNextHandler) {
	let classVal = "filenode";
	if (isMenuIncludeFile) {
		classVal = "filenode lact";
		prevNextHandler.nxt = "input";
	}
	if (prevNextHandler.nxt == "input" && !isMenuIncludeFile) {
		prevNextHandler.nxt = menuLink;
	} else if (prevNextHandler.nxt.length == 0 && !isIndex) {
		prevNextHandler.pre = menuLink;
	}
	return classVal;
}

function modifyLhsAndBred() {
	let fileNode = $(".filenode.lact");
	if(fileNode.length>1 && localStorage && undefined!=localStorage.getItem('adap-tree-id')){
		fileNode = $('#'+localStorage.getItem('adap-tree-id'))
		nextAndPrevUpdate(localStorage.getItem('adap-tree-id'));
	}
	let fileNodeText = fileNode.text();
	let HomeElement = $(".bred-sec ul li").first();
	if (fileNode.length) {
		while (true) {
			fileNode = fileNode.parent();
			const id = fileNode.attr("id");
			const className = fileNode.attr("class");
			const nodeName = fileNode.prop('nodeName');
			if (id == undefined) {
				continue;
			} else if (id == "content") {
				break;
			}

			if (nodeName == "UL" && className == "pagesList hide") {
				fileNode.attr("class", "pagesList");
				let aNode = fileNode.prev();
				aNode.find("span").attr("class", "plusminusicon imageMinus");
				if(aNode.length>1){

				}
				else{
					HomeElement.after(createBredCrumb("bvar", aNode.text()));
				}
			}
		}
		$(".bred-sec ul").append(createBredCrumb("bval", fileNodeText));
		$('.lhs').animate({ scrollTop: $(".filenode.lact").offset().top - 150 }, 300);
	}
}

function createBredCrumb(classVal, textVal) {
	
	let liElement = document.createElement("li");
	let spanElement = document.createElement("span");
	liElement.setAttribute('class', classVal);
	spanElement.textContent = textVal;
	liElement.appendChild(spanElement);
	return liElement;
}

function insertPrevNext(prefixForUrl, isIndex, prevNextHandler) {
	$(".pg-nav").find("ul").append(getListElement(prevNextHandler.pre, "pre", "prev", "Previous Topic"));
	$(".pg-nav").find("ul").append(getListElement(prevNextHandler.nxt, "nxt", "next", "Next Topic"));
}

function getListElement(hrefVal, classVal, relVal, textVal) {
	console.log(hrefVal)
	let liElement = document.createElement('li');
	let aElement = document.createElement('a');
	if (hrefVal != undefined && hrefVal.length != 0 && hrefVal != "input") {
		aElement.setAttribute('class', classVal);
		aElement.text = textVal;
		aElement.href = hrefVal;
		aElement.rel = relVal;
		liElement.append(aElement);
	}
	return liElement;
}
function nextAndPrevUpdate(id){
	setTimeout(function(id){
		var prev = $('#'+id).closest('li').prev().find('> a').attr('href');
	var next = $('#'+id).closest('li').next().find('> a').attr('href');
	if(next.indexOf('html')==-1){
		next = $('#'+id).closest('li').next().find('> ul > li:first-child a').attr('href')
	}
	if(prev.indexOf('html')==-1){
		prev = $('#'+id).closest('li').prev().find('> ul > li:first-child a').attr('href')
	}
	$('.pre').attr("href",prev);
	$('.nxt').attr("href",next);
	},0,id)
}
// ignorei18n_end