/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.net.jsse;

import java.io.IOException;
import java.security.KeyStore;
import java.security.SecureRandom;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.apache.tomcat.util.net.jsse.JSSESocketFactory;

public class JSSE14SocketFactory
extends JSSESocketFactory {
    void initProxy() throws IOException {
        try {
            String algorithm;
            String protocol;
            String keystorePass;
            String keyPass;
            String clientAuthStr;
            String keystoreFile = (String)this.attributes.get("keystore");
            if (keystoreFile == null) {
                keystoreFile = JSSESocketFactory.defaultKeystoreFile;
            }
            this.keystoreType = (String)this.attributes.get("keystoreType");
            if (this.keystoreType == null) {
                this.keystoreType = JSSESocketFactory.defaultKeystoreType;
            }
            if ((clientAuthStr = (String)this.attributes.get("clientauth")) != null) {
                if (clientAuthStr.equals("true")) {
                    this.clientAuth = true;
                } else if (clientAuthStr.equals("false")) {
                    this.clientAuth = false;
                } else {
                    throw new IOException("Invalid value '" + clientAuthStr + "' for 'clientauth' parameter:");
                }
            }
            if ((keyPass = (String)this.attributes.get("keypass")) == null) {
                keyPass = JSSESocketFactory.defaultKeyPass;
            }
            if ((keystorePass = (String)this.attributes.get("keystorePass")) == null) {
                keystorePass = keyPass;
            }
            if ((protocol = (String)this.attributes.get("protocol")) == null) {
                protocol = JSSESocketFactory.defaultProtocol;
            }
            if ((algorithm = (String)this.attributes.get("algorithm")) == null) {
                algorithm = JSSESocketFactory.defaultAlgorithm;
            }
            KeyStore kstore = this.initKeyStore(keystoreFile, keystorePass);
            SSLContext context = SSLContext.getInstance(protocol);
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(algorithm);
            kmf.init(kstore, keyPass.toCharArray());
            TrustManager[] tm = null;
            String trustStoreFile = System.getProperty("javax.net.ssl.trustStore");
            String trustStorePassword = System.getProperty("javax.net.ssl.trustStorePassword");
            if (trustStoreFile != null && trustStorePassword != null) {
                KeyStore trustStore = this.initKeyStore(trustStoreFile, trustStorePassword);
                TrustManagerFactory tmf = TrustManagerFactory.getInstance("SunX509");
                tmf.init(trustStore);
                tm = tmf.getTrustManagers();
            }
            context.init(kmf.getKeyManagers(), tm, new SecureRandom());
            this.sslProxy = context.getServerSocketFactory();
            return;
        }
        catch (Exception e) {
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw new IOException(e.getMessage());
        }
    }
}

