/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.net;

import java.io.IOException;
import java.net.Socket;
import org.apache.tomcat.util.collections.SimplePool;
import org.apache.tomcat.util.net.PoolTcpEndpoint;
import org.apache.tomcat.util.net.TcpConnection;
import org.apache.tomcat.util.threads.ThreadPoolRunnable;

class TcpWorkerThread
implements ThreadPoolRunnable {
    PoolTcpEndpoint endpoint;
    SimplePool connectionCache;
    static final boolean usePool = false;

    public TcpWorkerThread(PoolTcpEndpoint endpoint) {
        this.endpoint = endpoint;
    }

    public Object[] getInitData() {
        Object[] obj = new Object[2];
        obj[1] = this.endpoint.getConnectionHandler().init();
        obj[0] = new TcpConnection();
        return obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runIt(Object[] perThrData) {
        while (this.endpoint.isRunning()) {
            Socket s;
            block15: {
                s = null;
                try {
                    s = this.endpoint.acceptSocket();
                }
                catch (Throwable t) {
                    PoolTcpEndpoint.log.error("Exception in acceptSocket", t);
                    throw new IllegalStateException("Terminating thread");
                }
                if (null == s) continue;
                this.endpoint.tp.runIt(this);
                try {
                    if (this.endpoint.getServerSocketFactory() == null) break block15;
                    this.endpoint.getServerSocketFactory().handshake(s);
                }
                catch (Throwable t) {
                    PoolTcpEndpoint.log.debug("Handshake failed", t);
                    try {
                        s.close();
                    }
                    catch (IOException e) {}
                    break;
                }
            }
            TcpConnection con = null;
            try {
                con = (TcpConnection)perThrData[0];
                perThrData = (Object[])perThrData[1];
                con.setEndpoint(this.endpoint);
                con.setSocket(s);
                this.endpoint.setSocketOptions(s);
                this.endpoint.getConnectionHandler().processConnection(con, perThrData);
                break;
            }
            catch (Throwable t) {
                PoolTcpEndpoint.log.error("Unexpected error", t);
                try {
                    s.close();
                }
                catch (IOException e) {
                    // empty catch block
                }
                break;
            }
            finally {
                if (con != null) {
                    con.recycle();
                }
            }
        }
    }
}

