/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.net;

import java.net.Socket;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tomcat.util.net.SSLSupport;
import org.apache.tomcat.util.net.ServerSocketFactory;
import org.apache.tomcat.util.net.jsse.JSSEImplementation;

public abstract class SSLImplementation {
    private static Log logger = LogFactory.getLog(class$org$apache$tomcat$util$net$SSLImplementation == null ? (class$org$apache$tomcat$util$net$SSLImplementation = SSLImplementation.class$("org.apache.tomcat.util.net.SSLImplementation")) : class$org$apache$tomcat$util$net$SSLImplementation);
    private static final String PureTLSImplementationClass = "org.apache.tomcat.util.net.puretls.PureTLSImplementation";
    private static final String JSSEImplementationClass = "org.apache.tomcat.util.net.jsse.JSSEImplementation";
    private static final String[] implementations = new String[]{"org.apache.tomcat.util.net.puretls.PureTLSImplementation", "org.apache.tomcat.util.net.jsse.JSSEImplementation"};
    static /* synthetic */ Class class$org$apache$tomcat$util$net$SSLImplementation;

    public static SSLImplementation getInstance() throws ClassNotFoundException {
        for (int i = 0; i < implementations.length; ++i) {
            try {
                SSLImplementation impl = SSLImplementation.getInstance(implementations[i]);
                return impl;
            }
            catch (Exception e) {
                if (!logger.isTraceEnabled()) continue;
                logger.trace("Error creating " + implementations[i], e);
                continue;
            }
        }
        throw new ClassNotFoundException("Can't find any SSL implementation");
    }

    public static SSLImplementation getInstance(String className) throws ClassNotFoundException {
        if (className == null) {
            return SSLImplementation.getInstance();
        }
        try {
            if (JSSEImplementationClass.equals(className)) {
                return new JSSEImplementation();
            }
            Class<?> clazz = Class.forName(className);
            return (SSLImplementation)clazz.newInstance();
        }
        catch (Exception e) {
            if (logger.isDebugEnabled()) {
                logger.debug("Error loading SSL Implementation " + className, e);
            }
            throw new ClassNotFoundException("Error loading SSL Implementation " + className + " :" + e.toString());
        }
    }

    public abstract String getImplementationName();

    public abstract ServerSocketFactory getServerSocketFactory();

    public abstract SSLSupport getSSLSupport(Socket var1);

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

