/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.http11.filters;

import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.coyote.OutputBuffer;
import org.apache.coyote.Response;
import org.apache.coyote.http11.OutputFilter;
import org.apache.tomcat.util.buf.ByteChunk;

public class GzipOutputFilter
implements OutputFilter {
    protected static final String ENCODING_NAME = "gzip";
    protected static final ByteChunk ENCODING = new ByteChunk();
    protected OutputBuffer buffer;
    protected GZIPOutputStream compressionStream = null;
    protected OutputStream fakeOutputStream = new FakeOutputStream();

    public int doWrite(ByteChunk chunk, Response res) throws IOException {
        if (this.compressionStream == null) {
            this.compressionStream = new GZIPOutputStream(this.fakeOutputStream);
        }
        this.compressionStream.write(chunk.getBytes(), chunk.getStart(), chunk.getLength());
        return chunk.getLength();
    }

    public void setResponse(Response response) {
    }

    public void setBuffer(OutputBuffer buffer) {
        this.buffer = buffer;
    }

    public long end() throws IOException {
        if (this.compressionStream == null) {
            this.compressionStream = new GZIPOutputStream(this.fakeOutputStream);
        }
        this.compressionStream.finish();
        return ((OutputFilter)this.buffer).end();
    }

    public void recycle() {
        this.compressionStream = null;
    }

    public ByteChunk getEncodingName() {
        return ENCODING;
    }

    static {
        ENCODING.setBytes(ENCODING_NAME.getBytes(), 0, ENCODING_NAME.length());
    }

    protected class FakeOutputStream
    extends OutputStream {
        protected ByteChunk outputChunk = new ByteChunk();

        protected FakeOutputStream() {
        }

        public void write(int b) {
            System.out.println("FIXME");
        }

        public void write(byte[] b, int off, int len) throws IOException {
            this.outputChunk.setBytes(b, off, len);
            GzipOutputFilter.this.buffer.doWrite(this.outputChunk, null);
        }

        public void flush() throws IOException {
        }

        public void close() throws IOException {
        }
    }
}

