/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.modeler;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanNotificationInfo;
import javax.management.Notification;
import javax.management.NotificationBroadcaster;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import org.apache.commons.modeler.BaseAttributeFilter;
import org.apache.commons.modeler.BaseNotificationBroadcasterEntry;

public class BaseNotificationBroadcaster
implements NotificationBroadcaster {
    protected ArrayList entries = new ArrayList();

    public void addNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) throws IllegalArgumentException {
        ArrayList arrayList = this.entries;
        synchronized (arrayList) {
            if (filter instanceof BaseAttributeFilter) {
                BaseAttributeFilter newFilter = (BaseAttributeFilter)filter;
                Iterator items = ((AbstractList)this.entries).iterator();
                while (items.hasNext()) {
                    BaseNotificationBroadcasterEntry item = (BaseNotificationBroadcasterEntry)items.next();
                    if (item.listener != listener || item.filter == null || !(item.filter instanceof BaseAttributeFilter) || item.handback != handback) continue;
                    BaseAttributeFilter oldFilter = (BaseAttributeFilter)item.filter;
                    String[] newNames = newFilter.getNames();
                    String[] oldNames = oldFilter.getNames();
                    if (newNames.length == 0) {
                        oldFilter.clear();
                    } else if (oldNames.length != 0) {
                        int i = 0;
                        while (i < newNames.length) {
                            oldFilter.addAttribute(newNames[i]);
                            ++i;
                        }
                    }
                    return;
                }
            }
            this.entries.add(new BaseNotificationBroadcasterEntry(listener, filter, handback));
        }
    }

    public MBeanNotificationInfo[] getNotificationInfo() {
        return new MBeanNotificationInfo[0];
    }

    public void removeNotificationListener(NotificationListener listener) throws ListenerNotFoundException {
        ArrayList arrayList = this.entries;
        synchronized (arrayList) {
            Iterator items = ((AbstractList)this.entries).iterator();
            while (items.hasNext()) {
                BaseNotificationBroadcasterEntry item = (BaseNotificationBroadcasterEntry)items.next();
                if (item.listener != listener) continue;
                items.remove();
            }
        }
    }

    public void removeNotificationListener(NotificationListener listener, Object handback) throws ListenerNotFoundException {
        this.removeNotificationListener(listener);
    }

    public void removeNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) throws ListenerNotFoundException {
        this.removeNotificationListener(listener);
    }

    public void sendNotification(Notification notification) {
        ArrayList arrayList = this.entries;
        synchronized (arrayList) {
            Iterator items = ((AbstractList)this.entries).iterator();
            while (items.hasNext()) {
                BaseNotificationBroadcasterEntry item = (BaseNotificationBroadcasterEntry)items.next();
                if (item.filter != null && !item.filter.isNotificationEnabled(notification)) continue;
                item.listener.handleNotification(notification, item.handback);
            }
        }
    }
}

