/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.authenticator;

import java.io.IOException;
import java.security.Principal;
import java.util.HashMap;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.HttpRequest;
import org.apache.catalina.HttpResponse;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Logger;
import org.apache.catalina.Request;
import org.apache.catalina.Response;
import org.apache.catalina.Session;
import org.apache.catalina.SessionEvent;
import org.apache.catalina.SessionListener;
import org.apache.catalina.ValveContext;
import org.apache.catalina.authenticator.SingleSignOnEntry;
import org.apache.catalina.util.LifecycleSupport;
import org.apache.catalina.util.StringManager;
import org.apache.catalina.valves.ValveBase;

public class SingleSignOn
extends ValveBase
implements Lifecycle,
SessionListener {
    protected HashMap cache = new HashMap();
    protected int debug = 0;
    protected static String info = "org.apache.catalina.authenticator.SingleSignOn";
    protected LifecycleSupport lifecycle = new LifecycleSupport(this);
    protected HashMap reverse = new HashMap();
    protected static final StringManager sm = StringManager.getManager("org.apache.catalina.authenticator");
    protected boolean started = false;

    public int getDebug() {
        return this.debug;
    }

    public void setDebug(int debug) {
        this.debug = debug;
    }

    public void addLifecycleListener(LifecycleListener listener) {
        this.lifecycle.addLifecycleListener(listener);
    }

    public LifecycleListener[] findLifecycleListeners() {
        return this.lifecycle.findLifecycleListeners();
    }

    public void removeLifecycleListener(LifecycleListener listener) {
        this.lifecycle.removeLifecycleListener(listener);
    }

    public void start() throws LifecycleException {
        if (this.started) {
            throw new LifecycleException(sm.getString("authenticator.alreadyStarted"));
        }
        this.lifecycle.fireLifecycleEvent("start", null);
        this.started = true;
        if (this.debug >= 1) {
            this.log("Started");
        }
    }

    public void stop() throws LifecycleException {
        if (!this.started) {
            throw new LifecycleException(sm.getString("authenticator.notStarted"));
        }
        this.lifecycle.fireLifecycleEvent("stop", null);
        this.started = false;
        if (this.debug >= 1) {
            this.log("Stopped");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sessionEvent(SessionEvent event) {
        if (!"destroySession".equals(event.getType())) {
            return;
        }
        Session session = event.getSession();
        if (this.debug >= 1) {
            this.log("Process session destroyed on " + session);
        }
        String ssoId = null;
        HashMap hashMap = this.reverse;
        synchronized (hashMap) {
            ssoId = (String)this.reverse.get(session);
        }
        if (ssoId == null) {
            return;
        }
        this.deregister(ssoId);
    }

    public String getInfo() {
        return info;
    }

    public void invoke(Request request, Response response, ValveContext context) throws IOException, ServletException {
        SingleSignOnEntry entry;
        if (!(request instanceof HttpRequest) || !(response instanceof HttpResponse)) {
            context.invokeNext(request, response);
            return;
        }
        HttpServletRequest hreq = (HttpServletRequest)request.getRequest();
        HttpServletResponse hres = (HttpServletResponse)response.getResponse();
        request.removeNote("org.apache.catalina.request.SSOID");
        if (this.debug >= 1) {
            this.log("Process request for '" + hreq.getRequestURI() + "'");
        }
        if (hreq.getUserPrincipal() != null) {
            if (this.debug >= 1) {
                this.log(" Principal '" + hreq.getUserPrincipal().getName() + "' has already been authenticated");
            }
            context.invokeNext(request, response);
            return;
        }
        if (this.debug >= 1) {
            this.log(" Checking for SSO cookie");
        }
        Cookie cookie = null;
        Cookie[] cookies = hreq.getCookies();
        if (cookies == null) {
            cookies = new Cookie[]{};
        }
        for (int i = 0; i < cookies.length; ++i) {
            if (!"JSESSIONIDSSO".equals(cookies[i].getName())) continue;
            cookie = cookies[i];
            break;
        }
        if (cookie == null) {
            if (this.debug >= 1) {
                this.log(" SSO cookie is not present");
            }
            context.invokeNext(request, response);
            return;
        }
        if (this.debug >= 1) {
            this.log(" Checking for cached principal for " + cookie.getValue());
        }
        if ((entry = this.lookup(cookie.getValue())) != null) {
            if (this.debug >= 1) {
                this.log(" Found cached principal '" + entry.principal.getName() + "' with auth type '" + entry.authType + "'");
            }
            request.setNote("org.apache.catalina.request.SSOID", cookie.getValue());
            ((HttpRequest)request).setAuthType(entry.authType);
            ((HttpRequest)request).setUserPrincipal(entry.principal);
        } else {
            if (this.debug >= 1) {
                this.log(" No cached principal found, erasing SSO cookie");
            }
            cookie.setMaxAge(0);
            hres.addCookie(cookie);
        }
        context.invokeNext(request, response);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("SingleSignOn[");
        sb.append(this.container.getName());
        sb.append("]");
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void associate(String ssoId, Session session) {
        SingleSignOnEntry sso;
        if (this.debug >= 1) {
            this.log("Associate sso id " + ssoId + " with session " + session);
        }
        if ((sso = this.lookup(ssoId)) != null) {
            sso.addSession(this, session);
        }
        HashMap hashMap = this.reverse;
        synchronized (hashMap) {
            this.reverse.put(session, ssoId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deregister(String ssoId) {
        if (this.debug >= 1) {
            this.log("Deregistering sso id '" + ssoId + "'");
        }
        SingleSignOnEntry sso = null;
        HashMap hashMap = this.cache;
        synchronized (hashMap) {
            sso = (SingleSignOnEntry)this.cache.remove(ssoId);
        }
        if (sso == null) {
            return;
        }
        Session[] sessions = sso.findSessions();
        for (int i = 0; i < sessions.length; ++i) {
            if (this.debug >= 2) {
                this.log(" Invalidating session " + sessions[i]);
            }
            HashMap hashMap2 = this.reverse;
            synchronized (hashMap2) {
                this.reverse.remove(sessions[i]);
            }
            sessions[i].expire();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void register(String ssoId, Principal principal, String authType, String username, String password) {
        if (this.debug >= 1) {
            this.log("Registering sso id '" + ssoId + "' for user '" + principal.getName() + "' with auth type '" + authType + "'");
        }
        HashMap hashMap = this.cache;
        synchronized (hashMap) {
            this.cache.put(ssoId, new SingleSignOnEntry(principal, authType, username, password));
        }
    }

    protected void log(String message) {
        Logger logger = this.container.getLogger();
        if (logger != null) {
            logger.log(this.toString() + ": " + message);
        } else {
            System.out.println(this.toString() + ": " + message);
        }
    }

    protected void log(String message, Throwable throwable) {
        Logger logger = this.container.getLogger();
        if (logger != null) {
            logger.log(this.toString() + ": " + message, throwable);
        } else {
            System.out.println(this.toString() + ": " + message);
            throwable.printStackTrace(System.out);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SingleSignOnEntry lookup(String ssoId) {
        HashMap hashMap = this.cache;
        synchronized (hashMap) {
            return (SingleSignOnEntry)this.cache.get(ssoId);
        }
    }
}

