/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ajp;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import org.apache.ajp.Ajp13;
import org.apache.ajp.Ajp13Packet;
import org.apache.ajp.AjpHandler;
import org.apache.ajp.Logger;
import org.apache.tomcat.util.buf.ByteChunk;
import org.apache.tomcat.util.buf.MessageBytes;
import org.apache.tomcat.util.http.BaseRequest;
import org.apache.tomcat.util.http.HttpMessages;
import org.apache.tomcat.util.http.MimeHeaders;

public class RequestHandler
extends AjpHandler {
    public static final byte JK_AJP13_FORWARD_REQUEST = 2;
    public static final byte JK_AJP13_SEND_BODY_CHUNK = 3;
    public static final byte JK_AJP13_SEND_HEADERS = 4;
    public static final byte JK_AJP13_END_RESPONSE = 5;
    public static final byte JK_AJP13_GET_BODY_CHUNK = 6;
    public static final int SC_RESP_CONTENT_TYPE = 40961;
    public static final int SC_RESP_CONTENT_LANGUAGE = 40962;
    public static final int SC_RESP_CONTENT_LENGTH = 40963;
    public static final int SC_RESP_DATE = 40964;
    public static final int SC_RESP_LAST_MODIFIED = 40965;
    public static final int SC_RESP_LOCATION = 40966;
    public static final int SC_RESP_SET_COOKIE = 40967;
    public static final int SC_RESP_SET_COOKIE2 = 40968;
    public static final int SC_RESP_SERVLET_ENGINE = 40969;
    public static final int SC_RESP_STATUS = 40970;
    public static final int SC_RESP_WWW_AUTHENTICATE = 40971;
    public static final byte SC_A_CONTEXT = 1;
    public static final byte SC_A_SERVLET_PATH = 2;
    public static final byte SC_A_REMOTE_USER = 3;
    public static final byte SC_A_AUTH_TYPE = 4;
    public static final byte SC_A_QUERY_STRING = 5;
    public static final byte SC_A_JVM_ROUTE = 6;
    public static final byte SC_A_SSL_CERT = 7;
    public static final byte SC_A_SSL_CIPHER = 8;
    public static final byte SC_A_SSL_SESSION = 9;
    public static final byte SC_A_SSL_KEY_SIZE = 11;
    public static final byte SC_A_SECRET = 12;
    public static final byte SC_A_REQ_ATTRIBUTE = 10;
    public static final byte SC_A_ARE_DONE = -1;
    public static final String[] methodTransArray = new String[]{"OPTIONS", "GET", "HEAD", "POST", "PUT", "DELETE", "TRACE", "PROPFIND", "PROPPATCH", "MKCOL", "COPY", "MOVE", "LOCK", "UNLOCK", "ACL", "REPORT", "VERSION-CONTROL", "CHECKIN", "CHECKOUT", "UNCHECKOUT", "SEARCH", "MKWORKSPACE", "UPDATE", "LABEL", "MERGE", "BASELINE-CONTROL", "MKACTIVITY"};
    public static final int SC_REQ_ACCEPT = 1;
    public static final int SC_REQ_ACCEPT_CHARSET = 2;
    public static final int SC_REQ_ACCEPT_ENCODING = 3;
    public static final int SC_REQ_ACCEPT_LANGUAGE = 4;
    public static final int SC_REQ_AUTHORIZATION = 5;
    public static final int SC_REQ_CONNECTION = 6;
    public static final int SC_REQ_CONTENT_TYPE = 7;
    public static final int SC_REQ_CONTENT_LENGTH = 8;
    public static final int SC_REQ_COOKIE = 9;
    public static final int SC_REQ_COOKIE2 = 10;
    public static final int SC_REQ_HOST = 11;
    public static final int SC_REQ_PRAGMA = 12;
    public static final int SC_REQ_REFERER = 13;
    public static final int SC_REQ_USER_AGENT = 14;
    public static final String[] headerTransArray = new String[]{"accept", "accept-charset", "accept-encoding", "accept-language", "authorization", "connection", "content-type", "content-length", "cookie", "cookie2", "host", "pragma", "referer", "user-agent"};
    private int debug = 0;
    private Logger logger = new Logger();

    public void init(Ajp13 ajp14) {
        ajp14.registerMessageType(2, "JK_AJP13_FORWARD_REQUEST", this, null);
        ajp14.registerMessageType(3, "JK_AJP13_SEND_BODY_CHUNK", this, null);
        ajp14.registerMessageType(4, "JK_AJP13_SEND_HEADERS", this, null);
        ajp14.registerMessageType(5, "JK_AJP13_END_RESPONSE", this, null);
        ajp14.registerMessageType(6, "JK_AJP13_GET_BODY_CHUNK", this, null);
    }

    public int handleAjpMessage(int type, Ajp13 channel, Ajp13Packet ajp, BaseRequest req) throws IOException {
        switch (type) {
            case 2: {
                return this.decodeRequest(channel, channel.hBuf, req);
            }
        }
        return -1;
    }

    protected int decodeRequest(Ajp13 ch, Ajp13Packet msg, BaseRequest req) throws IOException {
        if (this.debug > 0) {
            this.log("decodeRequest()");
        }
        boolean isSSL = false;
        byte methodCode = msg.getByte();
        req.method().setString(methodTransArray[methodCode - 1]);
        msg.getMessageBytes(req.protocol());
        msg.getMessageBytes(req.requestURI());
        msg.getMessageBytes(req.remoteAddr());
        msg.getMessageBytes(req.remoteHost());
        msg.getMessageBytes(req.serverName());
        req.setServerPort(msg.getInt());
        isSSL = msg.getBool();
        MimeHeaders headers = req.headers();
        int hCount = msg.getInt();
        for (int i = 0; i < hCount; ++i) {
            String hName = null;
            int isc = msg.peekInt();
            int hId = isc & 0xFF;
            MessageBytes vMB = null;
            if (40960 == (isc &= 0xFF00)) {
                msg.getInt();
                hName = headerTransArray[hId - 1];
                vMB = headers.addValue(hName);
                msg.getMessageBytes(vMB);
                if (hId == 8) {
                    int contentLength = vMB == null ? -1 : vMB.getInt();
                    req.setContentLength(contentLength);
                    continue;
                }
                if (hId == 7) {
                    ByteChunk bchunk = vMB.getByteChunk();
                    req.contentType().setBytes(bchunk.getBytes(), bchunk.getOffset(), bchunk.getLength());
                    continue;
                }
                if (hId != 5) continue;
                ByteChunk bchunk = vMB.getByteChunk();
                req.authorization().setBytes(bchunk.getBytes(), bchunk.getOffset(), bchunk.getLength());
                continue;
            }
            vMB = msg.addHeader(headers);
            if (vMB == null) {
                return 500;
            }
            msg.getMessageBytes(vMB);
        }
        byte attributeCode = msg.getByte();
        while (attributeCode != -1) {
            switch (attributeCode) {
                case 1: {
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    msg.getMessageBytes(req.remoteUser());
                    break;
                }
                case 4: {
                    msg.getMessageBytes(req.authType());
                    break;
                }
                case 5: {
                    msg.getMessageBytes(req.queryString());
                    break;
                }
                case 6: {
                    msg.getMessageBytes(req.jvmRoute());
                    break;
                }
                case 7: {
                    isSSL = true;
                    String certString = msg.getString();
                    byte[] certData = certString.getBytes();
                    ByteArrayInputStream bais = new ByteArrayInputStream(certData);
                    X509Certificate[] jsseCerts = null;
                    try {
                        CertificateFactory cf = CertificateFactory.getInstance("X.509");
                        X509Certificate cert = (X509Certificate)cf.generateCertificate(bais);
                        jsseCerts = new X509Certificate[]{cert};
                    }
                    catch (CertificateException e) {
                        this.log("Certificate convertion failed" + e);
                    }
                    req.setAttribute("javax.servlet.request.X509Certificate", (Object)jsseCerts);
                    break;
                }
                case 8: {
                    isSSL = true;
                    req.setAttribute("javax.servlet.request.cipher_suite", (Object)msg.getString());
                    break;
                }
                case 12: {
                    String secret = msg.getString();
                    if (secret == null) break;
                    ch.setSecret(secret);
                    break;
                }
                case 9: {
                    isSSL = true;
                    req.setAttribute("javax.servlet.request.ssl_session", (Object)msg.getString());
                    break;
                }
                case 10: {
                    req.setAttribute(msg.getString(), (Object)msg.getString());
                    break;
                }
                case 11: {
                    isSSL = true;
                    req.setAttribute("javax.servlet.request.key_size", (Object)Integer.toString(msg.getInt()));
                    break;
                }
                default: {
                    msg.getString();
                }
            }
            attributeCode = msg.getByte();
        }
        if (isSSL) {
            req.setScheme("https");
            req.setSecure(true);
        }
        req.cookies().setHeaders(req.headers());
        if (req.getContentLength() > 0) {
            int err = ch.receive(ch.inBuf);
            if (err < 0) {
                return 500;
            }
            ch.blen = ch.inBuf.peekInt();
            ch.pos = 0;
            ch.inBuf.getBytes(ch.bodyBuff);
        }
        if (this.debug > 5) {
            this.log(req.toString());
        }
        return 200;
    }

    public void sendHeaders(Ajp13 ch, Ajp13Packet outBuf, int status, String statusMessage, MimeHeaders headers) throws IOException {
        if (statusMessage == null) {
            statusMessage = HttpMessages.getMessage((int)status);
        }
        outBuf.reset();
        outBuf.appendByte((byte)4);
        outBuf.appendInt(status);
        outBuf.appendString(statusMessage);
        int numHeaders = headers.size();
        outBuf.appendInt(numHeaders);
        for (int i = 0; i < numHeaders; ++i) {
            String headerName = headers.getName(i).toString();
            int sc = this.headerNameToSc(headerName);
            if (-1 != sc) {
                outBuf.appendInt(sc);
            } else {
                outBuf.appendString(headerName);
            }
            outBuf.appendString(headers.getValue(i).toString());
        }
        outBuf.end();
        ch.send(outBuf);
    }

    public void finish(Ajp13 ch, Ajp13Packet outBuf) throws IOException {
        if (this.debug > 0) {
            this.log("finish()");
        }
        outBuf.reset();
        outBuf.appendByte((byte)5);
        outBuf.appendBool(true);
        outBuf.end();
        ch.send(outBuf);
    }

    public void doWrite(Ajp13 ch, Ajp13Packet outBuf, byte[] b, int off, int len) throws IOException {
        int to_send;
        if (this.debug > 0) {
            this.log("doWrite(byte[], " + off + ", " + len + ")");
        }
        for (int sent = 0; sent < len; sent += to_send) {
            to_send = len - sent;
            to_send = to_send > 8184 ? 8184 : to_send;
            outBuf.reset();
            outBuf.appendByte((byte)3);
            outBuf.appendBytes(b, off + sent, to_send);
            ch.send(outBuf);
        }
    }

    protected int headerNameToSc(String name) {
        switch (name.charAt(0)) {
            case 'C': 
            case 'c': {
                if (name.equalsIgnoreCase("Content-Type")) {
                    return 40961;
                }
                if (name.equalsIgnoreCase("Content-Language")) {
                    return 40962;
                }
                if (!name.equalsIgnoreCase("Content-Length")) break;
                return 40963;
            }
            case 'D': 
            case 'd': {
                if (!name.equalsIgnoreCase("Date")) break;
                return 40964;
            }
            case 'L': 
            case 'l': {
                if (name.equalsIgnoreCase("Last-Modified")) {
                    return 40965;
                }
                if (!name.equalsIgnoreCase("Location")) break;
                return 40966;
            }
            case 'S': 
            case 's': {
                if (name.equalsIgnoreCase("Set-Cookie")) {
                    return 40967;
                }
                if (!name.equalsIgnoreCase("Set-Cookie2")) break;
                return 40968;
            }
            case 'W': 
            case 'w': {
                if (!name.equalsIgnoreCase("WWW-Authenticate")) break;
                return 40971;
            }
        }
        return -1;
    }

    public void setDebug(int debug) {
        this.debug = debug;
    }

    public void setLogger(Logger l) {
        this.logger = l;
    }

    void log(String s) {
        this.logger.log("[RequestHandler] " + s);
    }

    public int available(Ajp13 ch) throws IOException {
        if (this.debug > 0) {
            this.log("available()");
        }
        if (ch.pos >= ch.blen && !this.refillReadBuffer(ch)) {
            return 0;
        }
        return ch.blen - ch.pos;
    }

    public int doRead(Ajp13 ch) throws IOException {
        if (this.debug > 0) {
            this.log("doRead()");
        }
        if (ch.pos >= ch.blen && !this.refillReadBuffer(ch)) {
            return -1;
        }
        return ch.bodyBuff[ch.pos++] & 0xFF;
    }

    public int doRead(Ajp13 ch, byte[] b, int off, int len) throws IOException {
        if (this.debug > 0) {
            this.log("doRead(byte[], int, int)");
        }
        if (ch.pos >= ch.blen && !this.refillReadBuffer(ch)) {
            return -1;
        }
        if (ch.pos + len <= ch.blen) {
            System.arraycopy(ch.bodyBuff, ch.pos, b, off, len);
            ch.pos += len;
            return len;
        }
        int toCopy = len;
        while (toCopy > 0) {
            int bytesRemaining = ch.blen - ch.pos;
            if (bytesRemaining < 0) {
                bytesRemaining = 0;
            }
            int c = bytesRemaining < toCopy ? bytesRemaining : toCopy;
            System.arraycopy(ch.bodyBuff, ch.pos, b, off, c);
            off += c;
            ch.pos += c;
            if ((toCopy -= c) <= 0 || this.refillReadBuffer(ch)) continue;
            break;
        }
        return len - toCopy;
    }

    public boolean refillReadBuffer(Ajp13 ch) throws IOException {
        if (this.debug > 0) {
            this.log("refillReadBuffer()");
        }
        ch.inBuf.reset();
        ch.inBuf.appendByte((byte)6);
        ch.inBuf.appendInt(8186);
        ch.send(ch.inBuf);
        int err = ch.receive(ch.inBuf);
        if (err < 0) {
            throw new IOException();
        }
        if (ch.inBuf.getLen() == 0) {
            if (this.debug > 0) {
                this.log("refillReadBuffer():  received empty packet -> end of stream");
            }
            ch.blen = 0;
            ch.pos = 0;
            return false;
        }
        ch.blen = ch.inBuf.peekInt();
        ch.pos = 0;
        ch.inBuf.getBytes(ch.bodyBuff);
        return ch.blen > 0;
    }

    public void beginSendHeaders(Ajp13 ch, Ajp13Packet outBuf, int status, String statusMessage, int numHeaders) throws IOException {
        if (this.debug > 0) {
            this.log("sendHeaders()");
        }
        outBuf.reset();
        outBuf.appendByte((byte)4);
        if (this.debug > 0) {
            this.log("status is:  " + status + "(" + statusMessage + ")");
        }
        outBuf.appendInt(status);
        outBuf.appendString(statusMessage);
        outBuf.appendInt(numHeaders);
    }

    public void sendHeader(Ajp13Packet outBuf, String name, String value) throws IOException {
        int sc = this.headerNameToSc(name);
        if (-1 != sc) {
            outBuf.appendInt(sc);
        } else {
            outBuf.appendString(name);
        }
        outBuf.appendString(value);
    }

    public void endSendHeaders(Ajp13 ch, Ajp13Packet outBuf) throws IOException {
        outBuf.end();
        ch.send(outBuf);
    }

    public void sendHeaders(Ajp13 ch, Ajp13Packet outBuf, int status, MimeHeaders headers) throws IOException {
        this.sendHeaders(ch, outBuf, status, HttpMessages.getMessage((int)status), headers);
    }
}

