/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ajp;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import org.apache.ajp.Ajp13Packet;
import org.apache.ajp.AjpHandler;
import org.apache.ajp.Logger;
import org.apache.ajp.RequestHandler;
import org.apache.tomcat.util.http.BaseRequest;
import org.apache.tomcat.util.http.HttpMessages;
import org.apache.tomcat.util.http.MimeHeaders;

public class Ajp13 {
    public static final int MAX_PACKET_SIZE = 8192;
    public static final int H_SIZE = 4;
    public static final int MAX_READ_SIZE = 8186;
    public static final int MAX_SEND_SIZE = 8184;
    public static final byte JK_AJP13_SHUTDOWN = 7;
    public static final int JK_AJP13_BAD_HEADER = -100;
    public static final int JK_AJP13_NO_HEADER = -101;
    public static final int JK_AJP13_COMM_CLOSED = -102;
    public static final int JK_AJP13_COMM_BROKEN = -103;
    public static final int JK_AJP13_BAD_BODY = -104;
    public static final int JK_AJP13_INCOMPLETE_BODY = -105;
    OutputStream out;
    InputStream in;
    public Ajp13Packet outBuf = new Ajp13Packet(8192);
    Ajp13Packet inBuf = new Ajp13Packet(8192);
    Ajp13Packet hBuf = new Ajp13Packet(8192);
    byte[] bodyBuff = new byte[8186];
    int blen;
    int pos;
    boolean end_of_stream;
    public RequestHandler reqHandler;
    boolean backwardCompat = true;
    boolean logged = false;
    String secret = null;
    static final int MAX_HANDLERS = 32;
    static final int RESERVED = 16;
    AjpHandler[] handlers = new AjpHandler[32];
    String[] handlerName = new String[32];
    int currentId = 16;
    protected int debug = 0;
    Logger logger = new Logger();

    public Ajp13() {
        this.initBuf();
        this.reqHandler = new RequestHandler();
        this.reqHandler.init(this);
    }

    public Ajp13(RequestHandler reqHandler) {
        this.initBuf();
        this.reqHandler = reqHandler;
        reqHandler.init(this);
    }

    public void initBuf() {
        this.outBuf = new Ajp13Packet(8192);
        this.inBuf = new Ajp13Packet(8192);
        this.hBuf = new Ajp13Packet(8192);
    }

    public void recycle() {
        if (this.debug > 0) {
            this.logger.log("recycle()");
        }
        this.blen = 0;
        this.pos = 0;
        this.end_of_stream = false;
        this.logged = false;
    }

    public void setSocket(Socket socket) throws IOException {
        if (this.debug > 0) {
            this.logger.log("setSocket()");
        }
        socket.setSoLinger(true, 100);
        this.out = socket.getOutputStream();
        this.in = socket.getInputStream();
        this.pos = 0;
    }

    public void setBackward(boolean b) {
        this.backwardCompat = b;
    }

    public boolean isLogged() {
        return this.logged;
    }

    void setLogged(boolean b) {
        this.logged = b;
    }

    public void setSecret(String s) {
        this.secret = s;
    }

    public String getSecret() {
        return this.secret;
    }

    public int registerMessageType(int id, String name, AjpHandler h, String[] sig) {
        if (id < 0) {
            for (int i = 0; i < this.handlerName.length; ++i) {
                if (!name.equals(this.handlerName[i])) continue;
                return i;
            }
            this.handlerName[this.currentId] = name;
            this.handlers[this.currentId] = h;
            ++this.currentId;
            return this.currentId;
        }
        this.handlerName[id] = name;
        this.handlers[id] = h;
        return id;
    }

    public int receiveNextRequest(BaseRequest req) throws IOException {
        if (this.debug > 0) {
            this.logger.log("receiveNextRequest()");
        }
        int err = 0;
        try {
            err = this.receive(this.hBuf);
        }
        catch (IOException ioe) {
            if (this.debug > 0) {
                this.logger.log("IOException receiving message ");
            }
            return -1;
        }
        if (err < 0) {
            if (this.debug > 0) {
                this.logger.log("Error receiving message ");
            }
            return 500;
        }
        byte type = this.hBuf.getByte();
        return this.handleMessage(type, this.hBuf, req);
    }

    public int handleMessage(int type, Ajp13Packet hBuf, BaseRequest req) throws IOException {
        if (type > this.handlers.length) {
            this.logger.log("Invalid handler " + type);
            return 500;
        }
        if (this.debug > 0) {
            this.logger.log("Received " + type + " " + this.handlerName[type]);
        }
        if (!this.backwardCompat && !this.isLogged() && type != 16 && type != 18) {
            this.logger.log("Ajp14 error: not logged " + type + " " + this.handlerName[type]);
            return 300;
        }
        switch (type) {
            case 2: {
                return this.reqHandler.decodeRequest(this, hBuf, req);
            }
            case 7: {
                return -2;
            }
        }
        AjpHandler handler = this.handlers[type];
        if (handler == null) {
            this.logger.log("Unknown message " + type + this.handlerName[type]);
            return 200;
        }
        if (this.debug > 0) {
            this.logger.log("Ajp14 handler " + handler);
        }
        return handler.handleAjpMessage(type, this, hBuf, req);
    }

    public int available() throws IOException {
        return this.reqHandler.available(this);
    }

    public int doRead() throws IOException {
        return this.reqHandler.doRead(this);
    }

    public int doRead(byte[] b, int off, int len) throws IOException {
        return this.reqHandler.doRead(this, b, off, len);
    }

    private boolean refillReadBuffer() throws IOException {
        return this.reqHandler.refillReadBuffer(this);
    }

    public void beginSendHeaders(int status, String statusMessage, int numHeaders) throws IOException {
        this.reqHandler.beginSendHeaders(this, this.outBuf, status, statusMessage, numHeaders);
    }

    public void sendHeader(String name, String value) throws IOException {
        this.reqHandler.sendHeader(this.outBuf, name, value);
    }

    public void endSendHeaders() throws IOException {
        this.reqHandler.endSendHeaders(this, this.outBuf);
    }

    public void sendHeaders(int status, MimeHeaders headers) throws IOException {
        this.reqHandler.sendHeaders(this, this.outBuf, status, HttpMessages.getMessage((int)status), headers);
    }

    public void sendHeaders(int status, String statusMessage, MimeHeaders headers) throws IOException {
        this.reqHandler.sendHeaders(this, this.outBuf, status, statusMessage, headers);
    }

    public void finish() throws IOException {
        this.reqHandler.finish(this, this.outBuf);
    }

    public void doWrite(byte[] b, int off, int len) throws IOException {
        this.reqHandler.doWrite(this, this.outBuf, b, off, len);
    }

    private int readN(InputStream in, byte[] b, int offset, int len) throws IOException {
        int pos;
        int got;
        for (pos = 0; pos < len; pos += got) {
            got = in.read(b, pos + offset, len - pos);
            if (this.debug > 10) {
                this.logger.log("read got # " + got);
            }
            if (got > 0) continue;
            return -103;
        }
        return pos;
    }

    public int receive(Ajp13Packet msg) throws IOException {
        byte[] b;
        int rd;
        if (this.debug > 0) {
            this.logger.log("receive()");
        }
        if ((rd = this.readN(this.in, b = msg.getBuff(), 0, 4)) < 0) {
            return rd;
        }
        int len = msg.checkIn();
        if (this.debug > 5) {
            this.logger.log("Received " + rd + " " + len + " " + b[0]);
        }
        int total_read = 0;
        total_read = this.readN(this.in, b, 4, len);
        if (total_read < 0) {
            this.logger.log("can't read body, waited #" + len);
            return -104;
        }
        if (total_read != len) {
            this.logger.log("incomplete read, waited #" + len + " got only " + total_read);
            return -105;
        }
        if (this.debug > 0) {
            this.logger.log("receive:  total read = " + total_read);
        }
        return total_read;
    }

    public void send(Ajp13Packet msg) throws IOException {
        if (this.debug > 0) {
            this.logger.log("send()");
        }
        msg.end();
        byte[] b = msg.getBuff();
        int len = msg.getLen();
        if (this.debug > 5) {
            this.logger.log("send() " + len + " " + b[0]);
        }
        this.out.write(b, 0, len);
    }

    public void close() throws IOException {
        if (this.debug > 0) {
            this.logger.log("close()");
        }
        if (null != this.out) {
            this.out.close();
        }
        if (null != this.in) {
            this.in.close();
        }
        this.setLogged(false);
    }

    public void setDebug(int debug) {
        this.debug = debug;
        this.reqHandler.setDebug(debug);
    }

    public void setLogger(Logger l) {
        this.logger = l;
        this.reqHandler.setLogger(l);
    }
}

