/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.net.jsse;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tomcat.util.net.SSLSupport;

class JSSESupport
implements SSLSupport {
    private Log log = LogFactory.getLog(class$org$apache$tomcat$util$net$jsse$JSSESupport == null ? (class$org$apache$tomcat$util$net$jsse$JSSESupport = JSSESupport.class$("org.apache.tomcat.util.net.jsse.JSSESupport")) : class$org$apache$tomcat$util$net$jsse$JSSESupport);
    protected SSLSocket ssl;
    static /* synthetic */ Class class$org$apache$tomcat$util$net$jsse$JSSESupport;

    JSSESupport(SSLSocket sock) {
        this.ssl = sock;
    }

    public String getCipherSuite() throws IOException {
        SSLSession session = this.ssl.getSession();
        if (session == null) {
            return null;
        }
        return session.getCipherSuite();
    }

    public Object[] getPeerCertificateChain() throws IOException {
        return this.getPeerCertificateChain(false);
    }

    protected X509Certificate[] getX509Certificates(SSLSession session) throws IOException {
        javax.security.cert.X509Certificate[] jsseCerts = null;
        jsseCerts = session.getPeerCertificateChain();
        if (jsseCerts == null) {
            jsseCerts = new javax.security.cert.X509Certificate[]{};
        }
        X509Certificate[] x509Certs = new X509Certificate[jsseCerts.length];
        for (int i = 0; i < x509Certs.length; ++i) {
            try {
                byte[] buffer = jsseCerts[i].getEncoded();
                CertificateFactory cf = CertificateFactory.getInstance("X.509");
                ByteArrayInputStream stream = new ByteArrayInputStream(buffer);
                x509Certs[i] = (X509Certificate)cf.generateCertificate(stream);
                if (!this.log.isTraceEnabled()) continue;
                this.log.trace("Cert #" + i + " = " + x509Certs[i]);
                continue;
            }
            catch (Exception ex) {
                this.log.info("Error translating " + jsseCerts[i], ex);
                return null;
            }
        }
        if (x509Certs.length < 1) {
            return null;
        }
        return x509Certs;
    }

    public Object[] getPeerCertificateChain(boolean force) throws IOException {
        SSLSession session = this.ssl.getSession();
        if (session == null) {
            return null;
        }
        javax.security.cert.X509Certificate[] jsseCerts = null;
        try {
            jsseCerts = session.getPeerCertificateChain();
        }
        catch (Exception bex) {
            // empty catch block
        }
        if (jsseCerts == null) {
            jsseCerts = new javax.security.cert.X509Certificate[]{};
        }
        if (jsseCerts.length <= 0 && force) {
            session.invalidate();
            this.handShake();
            session = this.ssl.getSession();
        }
        return this.getX509Certificates(session);
    }

    protected void handShake() throws IOException {
        this.ssl.setNeedClientAuth(true);
        this.ssl.startHandshake();
    }

    public Integer getKeySize() throws IOException {
        SSLSession session = this.ssl.getSession();
        SSLSupport.CipherData[] c_aux = SSLSupport.ciphers;
        if (session == null) {
            return null;
        }
        Integer keySize = (Integer)session.getValue("javax.servlet.request.key_size");
        if (keySize == null) {
            int size = 0;
            String cipherSuite = session.getCipherSuite();
            for (int i = 0; i < c_aux.length; ++i) {
                if (cipherSuite.indexOf(c_aux[i].phrase) < 0) continue;
                size = c_aux[i].keySize;
                break;
            }
            keySize = new Integer(size);
            session.putValue("javax.servlet.request.key_size", keySize);
        }
        return keySize;
    }

    public String getSessionId() throws IOException {
        SSLSession session = this.ssl.getSession();
        if (session == null) {
            return null;
        }
        byte[] ssl_session = session.getId();
        if (ssl_session == null) {
            return null;
        }
        StringBuffer buf = new StringBuffer("");
        for (int x = 0; x < ssl_session.length; ++x) {
            String digit = Integer.toHexString(ssl_session[x]);
            if (digit.length() < 2) {
                buf.append('0');
            }
            if (digit.length() > 2) {
                digit = digit.substring(digit.length() - 2);
            }
            buf.append(digit);
        }
        return buf.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

