/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.startup;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.Socket;
import java.security.Security;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.Server;
import org.apache.catalina.startup.ContextRuleSet;
import org.apache.catalina.startup.EngineRuleSet;
import org.apache.catalina.startup.HostRuleSet;
import org.apache.catalina.startup.NamingRuleSet;
import org.apache.catalina.startup.SetParentClassLoaderRule;
import org.apache.commons.digester.Digester;
import org.apache.commons.digester.Rule;
import org.apache.commons.digester.RuleSet;
import org.apache.tomcat.util.log.SystemLogHandler;
import org.xml.sax.InputSource;

public class Catalina {
    protected String configFile = "conf/server.xml";
    protected boolean debug = false;
    protected ClassLoader parentClassLoader = ClassLoader.getSystemClassLoader();
    protected Server server = null;
    protected boolean starting = false;
    protected boolean stopping = false;
    protected boolean useNaming = true;

    public static void main(String[] stringArray) {
        new Catalina().process(stringArray);
    }

    public void process(String[] stringArray) {
        this.setCatalinaHome();
        this.setCatalinaBase();
        try {
            if (this.arguments(stringArray)) {
                this.execute();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
        }
    }

    public void setParentClassLoader(ClassLoader classLoader) {
        this.parentClassLoader = classLoader;
    }

    public void setServer(Server server) {
        this.server = server;
    }

    protected boolean arguments(String[] stringArray) {
        boolean bl = false;
        if (stringArray.length < 1) {
            this.usage();
            return false;
        }
        int n = 0;
        while (n < stringArray.length) {
            if (bl) {
                this.configFile = stringArray[n];
                bl = false;
            } else if (stringArray[n].equals("-config")) {
                bl = true;
            } else if (stringArray[n].equals("-debug")) {
                this.debug = true;
            } else if (stringArray[n].equals("-nonaming")) {
                this.useNaming = false;
            } else {
                if (stringArray[n].equals("-help")) {
                    this.usage();
                    return false;
                }
                if (stringArray[n].equals("start")) {
                    this.starting = true;
                } else if (stringArray[n].equals("stop")) {
                    this.stopping = true;
                } else {
                    this.usage();
                    return false;
                }
            }
            ++n;
        }
        return true;
    }

    protected File configFile() {
        File file = new File(this.configFile);
        if (!file.isAbsolute()) {
            file = new File(System.getProperty("catalina.base"), this.configFile);
        }
        return file;
    }

    protected Digester createStartDigester() {
        Digester digester = new Digester();
        if (this.debug) {
            digester.setDebug(999);
        }
        digester.setValidating(false);
        digester.addObjectCreate("Server", "org.apache.catalina.core.StandardServer", "className");
        digester.addSetProperties("Server");
        digester.addSetNext("Server", "setServer", "org.apache.catalina.Server");
        digester.addObjectCreate("Server/GlobalNamingResources", "org.apache.catalina.deploy.NamingResources");
        digester.addSetProperties("Server/GlobalNamingResources");
        digester.addSetNext("Server/GlobalNamingResources", "setGlobalNamingResources", "org.apache.catalina.deploy.NamingResources");
        digester.addObjectCreate("Server/Listener", null, "className");
        digester.addSetProperties("Server/Listener");
        digester.addSetNext("Server/Listener", "addLifecycleListener", "org.apache.catalina.LifecycleListener");
        digester.addObjectCreate("Server/Service", "org.apache.catalina.core.StandardService", "className");
        digester.addSetProperties("Server/Service");
        digester.addSetNext("Server/Service", "addService", "org.apache.catalina.Service");
        digester.addObjectCreate("Server/Service/Listener", null, "className");
        digester.addSetProperties("Server/Service/Listener");
        digester.addSetNext("Server/Service/Listener", "addLifecycleListener", "org.apache.catalina.LifecycleListener");
        digester.addObjectCreate("Server/Service/Connector", "org.apache.catalina.connector.http.HttpConnector", "className");
        digester.addSetProperties("Server/Service/Connector");
        digester.addSetNext("Server/Service/Connector", "addConnector", "org.apache.catalina.Connector");
        digester.addObjectCreate("Server/Service/Connector/Factory", "org.apache.catalina.net.DefaultServerSocketFactory", "className");
        digester.addSetProperties("Server/Service/Connector/Factory");
        digester.addSetNext("Server/Service/Connector/Factory", "setFactory", "org.apache.catalina.net.ServerSocketFactory");
        digester.addObjectCreate("Server/Service/Connector/Listener", null, "className");
        digester.addSetProperties("Server/Service/Connector/Listener");
        digester.addSetNext("Server/Service/Connector/Listener", "addLifecycleListener", "org.apache.catalina.LifecycleListener");
        digester.addRuleSet((RuleSet)new NamingRuleSet("Server/GlobalNamingResources/"));
        digester.addRuleSet((RuleSet)new EngineRuleSet("Server/Service/"));
        digester.addRuleSet((RuleSet)new HostRuleSet("Server/Service/Engine/"));
        digester.addRuleSet((RuleSet)new ContextRuleSet("Server/Service/Engine/Default"));
        digester.addRuleSet((RuleSet)new NamingRuleSet("Server/Service/Engine/DefaultContext/"));
        digester.addRuleSet((RuleSet)new ContextRuleSet("Server/Service/Engine/Host/Default"));
        digester.addRuleSet((RuleSet)new NamingRuleSet("Server/Service/Engine/Host/DefaultContext/"));
        digester.addRuleSet((RuleSet)new ContextRuleSet("Server/Service/Engine/Host/"));
        digester.addRuleSet((RuleSet)new NamingRuleSet("Server/Service/Engine/Host/Context/"));
        digester.addRule("Server/Service/Engine", (Rule)new SetParentClassLoaderRule(digester, this.parentClassLoader));
        return digester;
    }

    protected Digester createStopDigester() {
        Digester digester = new Digester();
        if (this.debug) {
            digester.setDebug(999);
        }
        digester.addObjectCreate("Server", "org.apache.catalina.core.StandardServer", "className");
        digester.addSetProperties("Server");
        digester.addSetNext("Server", "setServer", "org.apache.catalina.Server");
        return digester;
    }

    protected void execute() throws Exception {
        if (this.starting) {
            this.start();
        } else if (this.stopping) {
            this.stop();
        }
    }

    protected void setCatalinaBase() {
        if (System.getProperty("catalina.base") != null) {
            return;
        }
        System.setProperty("catalina.base", System.getProperty("catalina.home"));
    }

    protected void setCatalinaHome() {
        if (System.getProperty("catalina.home") != null) {
            return;
        }
        System.setProperty("catalina.home", System.getProperty("user.dir"));
    }

    protected void start() {
        block19: {
            Object object;
            block18: {
                Object object2;
                Digester digester = this.createStartDigester();
                File file = this.configFile();
                try {
                    object = new InputSource("file://" + file.getAbsolutePath());
                    object2 = new FileInputStream(file);
                    ((InputSource)object).setByteStream((InputStream)object2);
                    digester.push((Object)this);
                    digester.parse((InputSource)object);
                    ((FileInputStream)object2).close();
                }
                catch (Exception exception) {
                    System.out.println("Catalina.start: " + exception);
                    exception.printStackTrace(System.out);
                    System.exit(1);
                }
                if (!this.useNaming) {
                    System.setProperty("catalina.useNaming", "false");
                } else {
                    System.setProperty("catalina.useNaming", "true");
                    object = "org.apache.naming";
                    object2 = System.getProperty("java.naming.factory.url.pkgs");
                    if (object2 != null) {
                        object = (String)object + ":" + (String)object2;
                    }
                    System.setProperty("java.naming.factory.url.pkgs", (String)object);
                    object = System.getProperty("java.naming.factory.initial");
                    if (object == null) {
                        System.setProperty("java.naming.factory.initial", "org.apache.naming.java.javaURLContextFactory");
                    }
                }
                if (System.getSecurityManager() != null) {
                    object = Security.getProperty("package.access");
                    object = object != null && ((String)object).length() > 0 ? (String)object + "," : "sun.,";
                    Security.setProperty("package.access", (String)object + "org.apache.catalina.,org.apache.jasper.");
                    object2 = Security.getProperty("package.definition");
                    object2 = object2 != null && ((String)object2).length() > 0 ? (String)object2 + "," : "sun.,";
                    Security.setProperty("package.definition", (String)object2 + "java.,org.apache.catalina.,org.apache.jasper.,org.apache.coyote.");
                }
                if (this.server.getOutputRedirect()) {
                    object = new SystemLogHandler(System.out);
                    System.setOut((PrintStream)object);
                    System.setErr((PrintStream)object);
                }
                object = new CatalinaShutdownHook();
                if (this.server instanceof Lifecycle) {
                    try {
                        this.server.initialize();
                        ((Lifecycle)((Object)this.server)).start();
                        try {
                            Runtime.getRuntime().addShutdownHook((Thread)object);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        this.server.await();
                    }
                    catch (LifecycleException lifecycleException) {
                        System.out.println("Catalina.start: " + lifecycleException);
                        lifecycleException.printStackTrace(System.out);
                        if (lifecycleException.getThrowable() == null) break block18;
                        System.out.println("----- Root Cause -----");
                        lifecycleException.getThrowable().printStackTrace(System.out);
                    }
                }
            }
            if (this.server instanceof Lifecycle) {
                try {
                    try {
                        Runtime.getRuntime().removeShutdownHook((Thread)object);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    ((Lifecycle)((Object)this.server)).stop();
                }
                catch (LifecycleException lifecycleException) {
                    System.out.println("Catalina.stop: " + lifecycleException);
                    lifecycleException.printStackTrace(System.out);
                    if (lifecycleException.getThrowable() == null) break block19;
                    System.out.println("----- Root Cause -----");
                    lifecycleException.getThrowable().printStackTrace(System.out);
                }
            }
        }
    }

    protected void stop() {
        Closeable closeable;
        Object object;
        Digester digester = this.createStopDigester();
        File file = this.configFile();
        try {
            object = new InputSource("file://" + file.getAbsolutePath());
            closeable = new FileInputStream(file);
            ((InputSource)object).setByteStream((InputStream)closeable);
            digester.push((Object)this);
            digester.parse((InputSource)object);
            ((FileInputStream)closeable).close();
        }
        catch (Exception exception) {
            System.out.println("Catalina.stop: " + exception);
            exception.printStackTrace(System.out);
            System.exit(1);
        }
        try {
            object = new Socket("127.0.0.1", this.server.getPort());
            closeable = ((Socket)object).getOutputStream();
            String string = this.server.getShutdown();
            int n = 0;
            while (n < string.length()) {
                ((OutputStream)closeable).write(string.charAt(n));
                ++n;
            }
            ((OutputStream)closeable).flush();
            ((OutputStream)closeable).close();
            ((Socket)object).close();
        }
        catch (IOException iOException) {
            System.out.println("Catalina.stop: " + iOException);
            iOException.printStackTrace(System.out);
            System.exit(1);
        }
    }

    protected void usage() {
        System.out.println("usage: java org.apache.catalina.startup.Catalina [ -config {pathname} ] [ -debug ] [ -nonaming ] { start | stop }");
    }

    protected class CatalinaShutdownHook
    extends Thread {
        protected CatalinaShutdownHook() {
        }

        public void run() {
            block3: {
                if (Catalina.this.server != null) {
                    try {
                        ((Lifecycle)((Object)Catalina.this.server)).stop();
                    }
                    catch (LifecycleException lifecycleException) {
                        System.out.println("Catalina.stop: " + lifecycleException);
                        lifecycleException.printStackTrace(System.out);
                        if (lifecycleException.getThrowable() == null) break block3;
                        System.out.println("----- Root Cause -----");
                        lifecycleException.getThrowable().printStackTrace(System.out);
                    }
                }
            }
        }
    }
}

