/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import java.beans.IndexedPropertyDescriptor;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyDescriptor;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.security.AccessControlException;
import java.sql.Timestamp;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Random;
import javax.naming.directory.DirContext;
import org.apache.catalina.Connector;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.DefaultContext;
import org.apache.catalina.Engine;
import org.apache.catalina.Host;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Loader;
import org.apache.catalina.Logger;
import org.apache.catalina.Manager;
import org.apache.catalina.Pipeline;
import org.apache.catalina.Realm;
import org.apache.catalina.Server;
import org.apache.catalina.ServerFactory;
import org.apache.catalina.Service;
import org.apache.catalina.Store;
import org.apache.catalina.Valve;
import org.apache.catalina.core.NamingContextListener;
import org.apache.catalina.core.StandardEngine;
import org.apache.catalina.core.StandardHost;
import org.apache.catalina.deploy.ApplicationParameter;
import org.apache.catalina.deploy.ContextEjb;
import org.apache.catalina.deploy.ContextEnvironment;
import org.apache.catalina.deploy.ContextLocalEjb;
import org.apache.catalina.deploy.ContextResource;
import org.apache.catalina.deploy.ContextResourceLink;
import org.apache.catalina.deploy.NamingResources;
import org.apache.catalina.deploy.ResourceParams;
import org.apache.catalina.loader.WebappLoader;
import org.apache.catalina.net.ServerSocketFactory;
import org.apache.catalina.session.PersistentManager;
import org.apache.catalina.session.StandardManager;
import org.apache.catalina.util.LifecycleSupport;
import org.apache.catalina.util.StringManager;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.naming.resources.FileDirContext;
import org.apache.naming.resources.ProxyDirContext;
import org.apache.naming.resources.WARDirContext;

public final class StandardServer
implements Lifecycle,
Server {
    private static String[][] exceptions = new String[][]{{"org.apache.catalina.core.StandardContext", "available"}, {"org.apache.catalina.core.StandardContext", "configured"}, {"org.apache.catalina.core.StandardContext", "distributable"}, {"org.apache.catalina.core.StandardContext", "name"}, {"org.apache.catalina.core.StandardContext", "override"}, {"org.apache.catalina.core.StandardContext", "publicId"}, {"org.apache.catalina.core.StandardContext", "replaceWelcomeFiles"}, {"org.apache.catalina.core.StandardContext", "sessionTimeout"}, {"org.apache.catalina.core.StandardContext", "workDir"}, {"org.apache.catalina.session.StandardManager", "distributable"}, {"org.apache.catalina.session.StandardManager", "entropy"}};
    private static Class[] persistables = new Class[]{class$java$lang$String == null ? (class$java$lang$String = StandardServer.class$("java.lang.String")) : class$java$lang$String, class$java$lang$Integer == null ? (class$java$lang$Integer = StandardServer.class$("java.lang.Integer")) : class$java$lang$Integer, Integer.TYPE, class$java$lang$Boolean == null ? (class$java$lang$Boolean = StandardServer.class$("java.lang.Boolean")) : class$java$lang$Boolean, Boolean.TYPE, class$java$lang$Byte == null ? (class$java$lang$Byte = StandardServer.class$("java.lang.Byte")) : class$java$lang$Byte, Byte.TYPE, class$java$lang$Character == null ? (class$java$lang$Character = StandardServer.class$("java.lang.Character")) : class$java$lang$Character, Character.TYPE, class$java$lang$Double == null ? (class$java$lang$Double = StandardServer.class$("java.lang.Double")) : class$java$lang$Double, Double.TYPE, class$java$lang$Float == null ? (class$java$lang$Float = StandardServer.class$("java.lang.Float")) : class$java$lang$Float, Float.TYPE, class$java$lang$Long == null ? (class$java$lang$Long = StandardServer.class$("java.lang.Long")) : class$java$lang$Long, Long.TYPE, class$java$lang$Short == null ? (class$java$lang$Short = StandardServer.class$("java.lang.Short")) : class$java$lang$Short, Short.TYPE};
    private static String[] skippables = new String[]{"org.apache.catalina.authenticator.BasicAuthenticator", "org.apache.catalina.authenticator.DigestAuthenticator", "org.apache.catalina.authenticator.FormAuthenticator", "org.apache.catalina.authenticator.NonLoginAuthenticator", "org.apache.catalina.authenticator.SSLAuthenticator", "org.apache.catalina.core.NamingContextListener", "org.apache.catalina.core.StandardContextValve", "org.apache.catalina.core.StandardDefaultContext", "org.apache.catalina.core.StandardEngineValve", "org.apache.catalina.core.StandardHostValve", "org.apache.catalina.startup.ContextConfig", "org.apache.catalina.startup.EngineConfig", "org.apache.catalina.startup.HostConfig", "org.apache.catalina.valves.CertificatesValve", "org.apache.catalina.valves.ErrorDispatcherValve", "org.apache.catalina.valves.ErrorReportValve"};
    private static String SERVER_LISTENER_CLASS_NAME = "org.apache.catalina.mbeans.ServerLifecycleListener";
    private int debug = 0;
    private javax.naming.Context globalNamingContext = null;
    private boolean outputRedirect = true;
    private NamingResources globalNamingResources = null;
    private static final String info = "org.apache.catalina.core.StandardServer/1.0";
    private LifecycleSupport lifecycle = new LifecycleSupport(this);
    private NamingContextListener namingContextListener = null;
    private int port = 8005;
    private Random random = null;
    private Service[] services = new Service[0];
    private String shutdown = "SHUTDOWN";
    private static final StringManager sm = StringManager.getManager("org.apache.catalina.core");
    private boolean started = false;
    private boolean initialized = false;
    protected PropertyChangeSupport support = new PropertyChangeSupport(this);
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Short;

    public StandardServer() {
        ServerFactory.setServer(this);
        this.globalNamingResources = new NamingResources();
        this.globalNamingResources.setContainer(this);
        if (this.isUseNaming() && this.namingContextListener == null) {
            this.namingContextListener = new NamingContextListener();
            this.namingContextListener.setDebug(this.getDebug());
            this.addLifecycleListener(this.namingContextListener);
        }
    }

    public int getDebug() {
        return this.debug;
    }

    public void setDebug(int n) {
        this.debug = n;
    }

    public boolean getOutputRedirect() {
        return this.outputRedirect;
    }

    public void setOutputRedirect(boolean bl) {
        this.outputRedirect = bl;
    }

    public javax.naming.Context getGlobalNamingContext() {
        return this.globalNamingContext;
    }

    public void setGlobalNamingContext(javax.naming.Context context) {
        this.globalNamingContext = context;
    }

    public NamingResources getGlobalNamingResources() {
        return this.globalNamingResources;
    }

    public void setGlobalNamingResources(NamingResources namingResources) {
        NamingResources namingResources2 = this.globalNamingResources;
        this.globalNamingResources = namingResources;
        this.globalNamingResources.setContainer(this);
        this.support.firePropertyChange("globalNamingResources", namingResources2, this.globalNamingResources);
    }

    public String getInfo() {
        return info;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int n) {
        this.port = n;
    }

    public String getShutdown() {
        return this.shutdown;
    }

    public void setShutdown(String string) {
        this.shutdown = string;
    }

    public void addService(Service service) {
        service.setServer(this);
        Service[] serviceArray = this.services;
        synchronized (serviceArray) {
            Service[] serviceArray2 = new Service[this.services.length + 1];
            System.arraycopy(this.services, 0, serviceArray2, 0, this.services.length);
            serviceArray2[this.services.length] = service;
            this.services = serviceArray2;
            if (this.initialized) {
                try {
                    service.initialize();
                }
                catch (LifecycleException lifecycleException) {
                    lifecycleException.printStackTrace(System.err);
                }
            }
            if (this.started && service instanceof Lifecycle) {
                try {
                    ((Lifecycle)((Object)service)).start();
                }
                catch (LifecycleException lifecycleException) {
                    // empty catch block
                }
            }
            this.support.firePropertyChange("service", null, service);
        }
    }

    public void await() {
        ServerSocket serverSocket = null;
        try {
            serverSocket = new ServerSocket(this.port, 1, InetAddress.getByName("127.0.0.1"));
        }
        catch (IOException iOException) {
            System.err.println("StandardServer.await: create[" + this.port + "]: " + iOException);
            iOException.printStackTrace();
            System.exit(1);
        }
        while (true) {
            int n;
            Socket socket = null;
            InputStream inputStream = null;
            try {
                socket = serverSocket.accept();
                socket.setSoTimeout(10000);
                inputStream = socket.getInputStream();
            }
            catch (AccessControlException accessControlException) {
                System.err.println("StandardServer.accept security exception: " + accessControlException.getMessage());
                continue;
            }
            catch (IOException iOException) {
                System.err.println("StandardServer.await: accept: " + iOException);
                iOException.printStackTrace();
                System.exit(1);
            }
            StringBuffer stringBuffer = new StringBuffer();
            int n2 = 1024;
            while (n2 < this.shutdown.length()) {
                if (this.random == null) {
                    this.random = new Random(System.currentTimeMillis());
                }
                n2 += this.random.nextInt() % 1024;
            }
            while (n2 > 0) {
                n = -1;
                try {
                    n = inputStream.read();
                }
                catch (IOException iOException) {
                    System.err.println("StandardServer.await: read: " + iOException);
                    iOException.printStackTrace();
                    n = -1;
                }
                if (n < 32) break;
                stringBuffer.append((char)n);
                --n2;
            }
            try {
                socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            n = stringBuffer.toString().equals(this.shutdown) ? 1 : 0;
            if (n != 0) break;
            System.err.println("StandardServer.await: Invalid command '" + stringBuffer.toString() + "' received");
        }
        try {
            serverSocket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public Service findService(String string) {
        if (string == null) {
            return null;
        }
        Service[] serviceArray = this.services;
        synchronized (serviceArray) {
            int n = 0;
            while (n < this.services.length) {
                if (string.equals(this.services[n].getName())) {
                    Service service = this.services[n];
                    return service;
                }
                ++n;
            }
        }
        return null;
    }

    public Service[] findServices() {
        return this.services;
    }

    public void removeService(Service service) {
        Service[] serviceArray = this.services;
        synchronized (serviceArray) {
            int n = -1;
            int n2 = 0;
            while (n2 < this.services.length) {
                if (service == this.services[n2]) {
                    n = n2;
                    break;
                }
                ++n2;
            }
            if (n < 0) {
                return;
            }
            if (this.services[n] instanceof Lifecycle) {
                try {
                    ((Lifecycle)((Object)this.services[n])).stop();
                }
                catch (LifecycleException lifecycleException) {
                    // empty catch block
                }
            }
            int n3 = 0;
            Service[] serviceArray2 = new Service[this.services.length - 1];
            int n4 = 0;
            while (n4 < this.services.length) {
                if (n4 != n) {
                    serviceArray2[n3++] = this.services[n4];
                }
                ++n4;
            }
            this.services = serviceArray2;
            this.support.firePropertyChange("service", service, null);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.removePropertyChangeListener(propertyChangeListener);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("StandardServer[");
        stringBuffer.append(this.getPort());
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public synchronized void store() throws Exception {
        File file;
        String string = "conf/server.xml";
        File file2 = new File(string);
        if (!file2.isAbsolute()) {
            file2 = new File(System.getProperty("catalina.base"), string);
        }
        if (!(file = new File(string + ".new")).isAbsolute()) {
            file = new File(System.getProperty("catalina.base"), string + ".new");
        }
        String string2 = new Timestamp(System.currentTimeMillis()).toString();
        StringBuffer stringBuffer = new StringBuffer(".");
        stringBuffer.append(string2.substring(0, 10));
        stringBuffer.append('.');
        stringBuffer.append(string2.substring(11, 13));
        stringBuffer.append('-');
        stringBuffer.append(string2.substring(14, 16));
        stringBuffer.append('-');
        stringBuffer.append(string2.substring(17, 19));
        File file3 = new File(string + stringBuffer.toString());
        if (!file3.isAbsolute()) {
            file3 = new File(System.getProperty("catalina.base"), string + stringBuffer.toString());
        }
        PrintWriter printWriter = null;
        try {
            printWriter = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF8"));
        }
        catch (IOException iOException) {
            if (printWriter != null) {
                try {
                    printWriter.close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            throw iOException;
        }
        try {
            this.storeServer(printWriter, 0, this);
        }
        catch (Exception exception) {
            if (printWriter != null) {
                try {
                    printWriter.close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            throw exception;
        }
        printWriter.flush();
        printWriter.close();
        if (file2.renameTo(file3)) {
            if (file.renameTo(file2)) {
                return;
            }
            file3.renameTo(file2);
            throw new IOException("Cannot rename " + file.getAbsolutePath() + " to " + file2.getAbsolutePath());
        }
        throw new IOException("Cannot rename " + file2.getAbsolutePath() + " to " + file3.getAbsolutePath());
    }

    private String convertStr(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length());
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (c == '<') {
                stringBuffer.append("&lt;");
            } else if (c == '>') {
                stringBuffer.append("&gt;");
            } else if (c == '\'') {
                stringBuffer.append("&apos;");
            } else if (c == '\"') {
                stringBuffer.append("&quot;");
            } else if (c == '&') {
                stringBuffer.append("&amp;");
            } else {
                stringBuffer.append(c);
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    private boolean isDefaultLoader(Loader loader) {
        if (!(loader instanceof WebappLoader)) {
            return false;
        }
        WebappLoader webappLoader = (WebappLoader)loader;
        return webappLoader.getCheckInterval() == 15 && webappLoader.getDebug() == 0 && !webappLoader.getDelegate() && webappLoader.getLoaderClass().equals("org.apache.catalina.loader.WebappClassLoader");
    }

    private boolean isDefaultManager(Manager manager) {
        if (!(manager instanceof StandardManager)) {
            return false;
        }
        StandardManager standardManager = (StandardManager)manager;
        return standardManager.getDebug() == 0 && standardManager.getPathname().equals("SESSIONS.ser") && standardManager.getCheckInterval() == 60 && standardManager.getRandomClass().equals("java.security.SecureRandom") && standardManager.getMaxActiveSessions() == -1 && standardManager.getAlgorithm().equals("MD5");
    }

    private boolean isException(String string, String string2) {
        int n = 0;
        while (n < exceptions.length) {
            if (string.equals(exceptions[n][0]) && string2.equals(exceptions[n][1])) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private boolean isPersistable(Class clazz) {
        int n = 0;
        while (n < persistables.length) {
            if (persistables[n] == clazz) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private boolean isSkippable(String string) {
        int n = 0;
        while (n < skippables.length) {
            if (skippables[n].equals(string)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private void storeAttributes(PrintWriter printWriter, Object object) throws Exception {
        this.storeAttributes(printWriter, true, object);
    }

    private void storeAttributes(PrintWriter printWriter, boolean bl, Object object) throws Exception {
        PropertyDescriptor[] propertyDescriptorArray;
        if (bl) {
            printWriter.print(" className=\"");
            printWriter.print(object.getClass().getName());
            printWriter.print("\"");
        }
        if ((propertyDescriptorArray = PropertyUtils.getPropertyDescriptors((Object)object)) == null) {
            propertyDescriptorArray = new PropertyDescriptor[]{};
        }
        String string = object.getClass().getName();
        int n = 0;
        while (n < propertyDescriptorArray.length) {
            Object object2;
            if (!(propertyDescriptorArray[n] instanceof IndexedPropertyDescriptor) && this.isPersistable(propertyDescriptorArray[n].getPropertyType()) && propertyDescriptorArray[n].getReadMethod() != null && propertyDescriptorArray[n].getWriteMethod() != null && (object2 = PropertyUtils.getSimpleProperty((Object)object, (String)propertyDescriptorArray[n].getName())) != null && !this.isException(string, propertyDescriptorArray[n].getName())) {
                if (!(object2 instanceof String)) {
                    object2 = object2.toString();
                }
                printWriter.print(' ');
                printWriter.print(propertyDescriptorArray[n].getName());
                printWriter.print("=\"");
                String string2 = this.convertStr((String)object2);
                printWriter.print(string2);
                printWriter.print("\"");
            }
            ++n;
        }
    }

    private void storeConnector(PrintWriter printWriter, int n, Connector connector) throws Exception {
        int n2 = 0;
        while (n2 < n) {
            printWriter.print(' ');
            ++n2;
        }
        printWriter.print("<Connector");
        this.storeAttributes(printWriter, connector);
        printWriter.println(">");
        ServerSocketFactory serverSocketFactory = connector.getFactory();
        if (serverSocketFactory != null) {
            this.storeFactory(printWriter, n + 2, serverSocketFactory);
        }
        if (connector instanceof Lifecycle) {
            LifecycleListener[] lifecycleListenerArray = ((Lifecycle)((Object)connector)).findLifecycleListeners();
            if (lifecycleListenerArray == null) {
                lifecycleListenerArray = new LifecycleListener[]{};
            }
            int n3 = 0;
            while (n3 < lifecycleListenerArray.length) {
                if (!lifecycleListenerArray[n3].getClass().getName().equals(SERVER_LISTENER_CLASS_NAME)) {
                    this.storeListener(printWriter, n + 2, lifecycleListenerArray[n3]);
                }
                ++n3;
            }
        }
        int n4 = 0;
        while (n4 < n) {
            printWriter.print(' ');
            ++n4;
        }
        printWriter.println("</Connector>");
    }

    private void storeContext(PrintWriter printWriter, int n, Context context) throws Exception {
        int n2;
        Object[] objectArray;
        Object object;
        Object object2;
        Logger logger;
        Loader loader;
        int n3 = 0;
        while (n3 < n) {
            printWriter.print(' ');
            ++n3;
        }
        printWriter.print("<Context");
        this.storeAttributes(printWriter, context);
        printWriter.println(">");
        String[] stringArray = context.findInstanceListeners();
        int n4 = 0;
        while (n4 < stringArray.length) {
            int n5 = 0;
            while (n5 < n) {
                printWriter.print(' ');
                ++n5;
            }
            printWriter.print("<InstanceListener>");
            printWriter.print(stringArray[n4]);
            printWriter.println("</InstanceListener>");
            ++n4;
        }
        if (context instanceof Lifecycle) {
            LifecycleListener[] lifecycleListenerArray = ((Lifecycle)((Object)context)).findLifecycleListeners();
            int n6 = 0;
            while (n6 < lifecycleListenerArray.length) {
                if (!lifecycleListenerArray[n6].getClass().getName().equals(SERVER_LISTENER_CLASS_NAME)) {
                    this.storeListener(printWriter, n + 2, lifecycleListenerArray[n6]);
                }
                ++n6;
            }
        }
        if ((loader = context.getLoader()) != null) {
            this.storeLoader(printWriter, n + 2, loader);
        }
        if ((logger = context.getLogger()) != null) {
            object2 = null;
            if (context.getParent() != null) {
                object2 = context.getParent().getLogger();
            }
            if (logger != object2) {
                this.storeLogger(printWriter, n + 2, logger);
            }
        }
        if ((object2 = context.getManager()) != null) {
            this.storeManager(printWriter, n + 2, (Manager)object2);
        }
        ApplicationParameter[] applicationParameterArray = context.findApplicationParameters();
        int n7 = 0;
        while (n7 < applicationParameterArray.length) {
            int n8 = 0;
            while (n8 < n + 2) {
                printWriter.print(' ');
                ++n8;
            }
            printWriter.print("<Parameter");
            this.storeAttributes(printWriter, false, applicationParameterArray[n7]);
            printWriter.println("/>");
            ++n7;
        }
        Realm realm = context.getRealm();
        if (realm != null) {
            object = null;
            if (context.getParent() != null) {
                object = context.getParent().getRealm();
            }
            if (realm != object) {
                this.storeRealm(printWriter, n + 2, realm);
            }
        }
        if ((object = context.getResources()) != null) {
            this.storeResources(printWriter, n + 2, (DirContext)object);
        }
        if (context instanceof Pipeline) {
            objectArray = ((Pipeline)((Object)context)).getValves();
            n2 = 0;
            while (n2 < objectArray.length) {
                this.storeValve(printWriter, n + 2, (Valve)objectArray[n2]);
                ++n2;
            }
        }
        objectArray = context.findWrapperLifecycles();
        n2 = 0;
        while (n2 < objectArray.length) {
            int n9 = 0;
            while (n9 < n) {
                printWriter.print(' ');
                ++n9;
            }
            printWriter.print("<WrapperLifecycle>");
            printWriter.print((String)objectArray[n2]);
            printWriter.println("</WrapperLifecycle>");
            ++n2;
        }
        String[] stringArray2 = context.findWrapperListeners();
        int n10 = 0;
        while (n10 < stringArray2.length) {
            int n11 = 0;
            while (n11 < n) {
                printWriter.print(' ');
                ++n11;
            }
            printWriter.print("<WrapperListener>");
            printWriter.print(stringArray2[n10]);
            printWriter.println("</WrapperListener>");
            ++n10;
        }
        NamingResources namingResources = context.getNamingResources();
        if (namingResources != null) {
            this.storeNamingResources(printWriter, n + 2, namingResources);
        }
        int n12 = 0;
        while (n12 < n) {
            printWriter.print(' ');
            ++n12;
        }
        printWriter.println("</Context>");
    }

    private void storeDefaultContext(PrintWriter printWriter, int n, DefaultContext defaultContext) throws Exception {
        int n2;
        Object[] objectArray;
        Manager manager;
        Loader loader;
        int n3 = 0;
        while (n3 < n) {
            printWriter.print(' ');
            ++n3;
        }
        printWriter.print("<DefaultContext");
        this.storeAttributes(printWriter, defaultContext);
        printWriter.println(">");
        String[] stringArray = defaultContext.findInstanceListeners();
        int n4 = 0;
        while (n4 < stringArray.length) {
            int n5 = 0;
            while (n5 < n) {
                printWriter.print(' ');
                ++n5;
            }
            printWriter.print("<InstanceListener>");
            printWriter.print(stringArray[n4]);
            printWriter.println("</InstanceListener>");
            ++n4;
        }
        if (defaultContext instanceof Lifecycle) {
            LifecycleListener[] lifecycleListenerArray = ((Lifecycle)((Object)defaultContext)).findLifecycleListeners();
            int n6 = 0;
            while (n6 < lifecycleListenerArray.length) {
                if (!lifecycleListenerArray[n6].getClass().getName().equals(SERVER_LISTENER_CLASS_NAME)) {
                    this.storeListener(printWriter, n + 2, lifecycleListenerArray[n6]);
                }
                ++n6;
            }
        }
        if ((loader = defaultContext.getLoader()) != null) {
            this.storeLoader(printWriter, n + 2, loader);
        }
        if ((manager = defaultContext.getManager()) != null) {
            this.storeManager(printWriter, n + 2, manager);
        }
        ApplicationParameter[] applicationParameterArray = defaultContext.findApplicationParameters();
        int n7 = 0;
        while (n7 < applicationParameterArray.length) {
            int n8 = 0;
            while (n8 < n + 2) {
                printWriter.print(' ');
                ++n8;
            }
            printWriter.print("<Parameter");
            this.storeAttributes(printWriter, false, applicationParameterArray[n7]);
            printWriter.println("/>");
            ++n7;
        }
        DirContext dirContext = defaultContext.getResources();
        if (dirContext != null) {
            this.storeResources(printWriter, n + 2, dirContext);
        }
        if (defaultContext instanceof Pipeline) {
            objectArray = ((Pipeline)((Object)defaultContext)).getValves();
            n2 = 0;
            while (n2 < objectArray.length) {
                this.storeValve(printWriter, n + 2, (Valve)objectArray[n2]);
                ++n2;
            }
        }
        objectArray = defaultContext.findWrapperLifecycles();
        n2 = 0;
        while (n2 < objectArray.length) {
            int n9 = 0;
            while (n9 < n) {
                printWriter.print(' ');
                ++n9;
            }
            printWriter.print("<WrapperLifecycle>");
            printWriter.print((String)objectArray[n2]);
            printWriter.println("</WrapperLifecycle>");
            ++n2;
        }
        String[] stringArray2 = defaultContext.findWrapperListeners();
        int n10 = 0;
        while (n10 < stringArray2.length) {
            int n11 = 0;
            while (n11 < n) {
                printWriter.print(' ');
                ++n11;
            }
            printWriter.print("<WrapperListener>");
            printWriter.print(stringArray2[n10]);
            printWriter.println("</WrapperListener>");
            ++n10;
        }
        NamingResources namingResources = defaultContext.getNamingResources();
        if (namingResources != null) {
            this.storeNamingResources(printWriter, n + 2, namingResources);
        }
        int n12 = 0;
        while (n12 < n) {
            printWriter.print(' ');
            ++n12;
        }
        printWriter.println("</DefaultContext>");
    }

    private void storeEngine(PrintWriter printWriter, int n, Engine engine) throws Exception {
        Object object;
        Realm realm;
        LifecycleListener[] lifecycleListenerArray;
        Object object2;
        int n2 = 0;
        while (n2 < n) {
            printWriter.print(' ');
            ++n2;
        }
        printWriter.print("<Engine");
        this.storeAttributes(printWriter, engine);
        printWriter.println(">");
        if (engine instanceof StandardEngine && (object2 = ((StandardEngine)engine).getDefaultContext()) != null) {
            this.storeDefaultContext(printWriter, n + 2, (DefaultContext)object2);
        }
        object2 = engine.findChildren();
        int n3 = 0;
        while (n3 < ((Container[])object2).length) {
            if (object2[n3] instanceof Context) {
                this.storeContext(printWriter, n + 2, (Context)object2[n3]);
            } else if (object2[n3] instanceof Engine) {
                this.storeEngine(printWriter, n + 2, (Engine)object2[n3]);
            } else if (object2[n3] instanceof Host) {
                this.storeHost(printWriter, n + 2, (Host)object2[n3]);
            }
            ++n3;
        }
        if (engine instanceof Lifecycle) {
            lifecycleListenerArray = ((Lifecycle)((Object)engine)).findLifecycleListeners();
            int n4 = 0;
            while (n4 < lifecycleListenerArray.length) {
                if (!lifecycleListenerArray[n4].getClass().getName().equals(SERVER_LISTENER_CLASS_NAME)) {
                    this.storeListener(printWriter, n + 2, lifecycleListenerArray[n4]);
                }
                ++n4;
            }
        }
        if ((lifecycleListenerArray = engine.getLogger()) != null) {
            Logger logger = null;
            if (engine.getParent() != null) {
                logger = engine.getParent().getLogger();
            }
            if (lifecycleListenerArray != logger) {
                this.storeLogger(printWriter, n + 2, (Logger)lifecycleListenerArray);
            }
        }
        if ((realm = engine.getRealm()) != null) {
            object = null;
            if (engine.getParent() != null) {
                object = engine.getParent().getRealm();
            }
            if (realm != object) {
                this.storeRealm(printWriter, n + 2, realm);
            }
        }
        if (engine instanceof Pipeline) {
            object = ((Pipeline)((Object)engine)).getValves();
            int n5 = 0;
            while (n5 < ((Valve[])object).length) {
                this.storeValve(printWriter, n + 2, object[n5]);
                ++n5;
            }
        }
        int n6 = 0;
        while (n6 < n) {
            printWriter.print(' ');
            ++n6;
        }
        printWriter.println("</Engine>");
    }

    private void storeFactory(PrintWriter printWriter, int n, ServerSocketFactory serverSocketFactory) throws Exception {
        int n2 = 0;
        while (n2 < n) {
            printWriter.print(' ');
            ++n2;
        }
        printWriter.print("<Factory");
        this.storeAttributes(printWriter, serverSocketFactory);
        printWriter.println("/>");
    }

    private void storeHost(PrintWriter printWriter, int n, Host host) throws Exception {
        Object object;
        Object object2;
        LifecycleListener[] lifecycleListenerArray;
        int n2 = 0;
        while (n2 < n) {
            printWriter.print(' ');
            ++n2;
        }
        printWriter.print("<Host");
        this.storeAttributes(printWriter, host);
        printWriter.println(">");
        String[] stringArray = host.findAliases();
        int n3 = 0;
        while (n3 < stringArray.length) {
            int n4 = 0;
            while (n4 < n) {
                printWriter.print(' ');
                ++n4;
            }
            printWriter.print("<Alias>");
            printWriter.print(stringArray[n3]);
            printWriter.println("</Alias>");
            ++n3;
        }
        Container[] containerArray = host.findChildren();
        int n5 = 0;
        while (n5 < containerArray.length) {
            if (containerArray[n5] instanceof Context) {
                this.storeContext(printWriter, n + 2, (Context)containerArray[n5]);
            } else if (containerArray[n5] instanceof Engine) {
                this.storeEngine(printWriter, n + 2, (Engine)containerArray[n5]);
            } else if (containerArray[n5] instanceof Host) {
                this.storeHost(printWriter, n + 2, (Host)containerArray[n5]);
            }
            ++n5;
        }
        if (host instanceof StandardHost && (lifecycleListenerArray = ((StandardHost)host).getDefaultContext()) != null && (object2 = host.getParent()) != null && object2 instanceof StandardEngine && lifecycleListenerArray != (object = ((StandardEngine)object2).getDefaultContext())) {
            this.storeDefaultContext(printWriter, n + 2, (DefaultContext)lifecycleListenerArray);
        }
        if (host instanceof Lifecycle) {
            lifecycleListenerArray = ((Lifecycle)((Object)host)).findLifecycleListeners();
            int n6 = 0;
            while (n6 < lifecycleListenerArray.length) {
                if (!lifecycleListenerArray[n6].getClass().getName().equals(SERVER_LISTENER_CLASS_NAME)) {
                    this.storeListener(printWriter, n + 2, lifecycleListenerArray[n6]);
                }
                ++n6;
            }
        }
        if ((lifecycleListenerArray = host.getLogger()) != null) {
            object2 = null;
            if (host.getParent() != null) {
                object2 = host.getParent().getLogger();
            }
            if (lifecycleListenerArray != object2) {
                this.storeLogger(printWriter, n + 2, (Logger)lifecycleListenerArray);
            }
        }
        if ((object2 = host.getRealm()) != null) {
            object = null;
            if (host.getParent() != null) {
                object = host.getParent().getRealm();
            }
            if (object2 != object) {
                this.storeRealm(printWriter, n + 2, (Realm)object2);
            }
        }
        if (host instanceof Pipeline) {
            object = ((Pipeline)((Object)host)).getValves();
            int n7 = 0;
            while (n7 < ((Valve[])object).length) {
                this.storeValve(printWriter, n + 2, object[n7]);
                ++n7;
            }
        }
        int n8 = 0;
        while (n8 < n) {
            printWriter.print(' ');
            ++n8;
        }
        printWriter.println("</Host>");
    }

    private void storeListener(PrintWriter printWriter, int n, LifecycleListener lifecycleListener) throws Exception {
        if (this.isSkippable(lifecycleListener.getClass().getName())) {
            return;
        }
        int n2 = 0;
        while (n2 < n) {
            printWriter.print(' ');
            ++n2;
        }
        printWriter.print("<Listener");
        this.storeAttributes(printWriter, lifecycleListener);
        printWriter.println("/>");
    }

    private void storeLoader(PrintWriter printWriter, int n, Loader loader) throws Exception {
        if (this.isDefaultLoader(loader)) {
            return;
        }
        int n2 = 0;
        while (n2 < n) {
            printWriter.print(' ');
            ++n2;
        }
        printWriter.print("<Loader");
        this.storeAttributes(printWriter, loader);
        printWriter.println("/>");
    }

    private void storeLogger(PrintWriter printWriter, int n, Logger logger) throws Exception {
        int n2 = 0;
        while (n2 < n) {
            printWriter.print(' ');
            ++n2;
        }
        printWriter.print("<Logger");
        this.storeAttributes(printWriter, logger);
        printWriter.println("/>");
    }

    private void storeManager(PrintWriter printWriter, int n, Manager manager) throws Exception {
        Store store;
        if (this.isDefaultManager(manager)) {
            return;
        }
        int n2 = 0;
        while (n2 < n) {
            printWriter.print(' ');
            ++n2;
        }
        printWriter.print("<Manager");
        this.storeAttributes(printWriter, manager);
        printWriter.println(">");
        if (manager instanceof PersistentManager && (store = ((PersistentManager)manager).getStore()) != null) {
            this.storeStore(printWriter, n + 2, store);
        }
        int n3 = 0;
        while (n3 < n) {
            printWriter.print(' ');
            ++n3;
        }
        printWriter.println("</Manager>");
    }

    private void storeNamingResources(PrintWriter printWriter, int n, NamingResources namingResources) throws Exception {
        int n2;
        int n3;
        int n4;
        ContextLocalEjb[] contextLocalEjbArray;
        int n5;
        ContextEnvironment[] contextEnvironmentArray;
        int n6;
        ContextEjb[] contextEjbArray = namingResources.findEjbs();
        if (contextEjbArray.length > 0) {
            int n7 = 0;
            while (n7 < contextEjbArray.length) {
                n6 = 0;
                while (n6 < n) {
                    printWriter.print(' ');
                    ++n6;
                }
                printWriter.print("<Ejb");
                this.storeAttributes(printWriter, false, contextEjbArray[n7]);
                printWriter.println("/>");
                ++n7;
            }
        }
        if ((contextEnvironmentArray = namingResources.findEnvironments()).length > 0) {
            n6 = 0;
            while (n6 < contextEnvironmentArray.length) {
                n5 = 0;
                while (n5 < n) {
                    printWriter.print(' ');
                    ++n5;
                }
                printWriter.print("<Environment");
                this.storeAttributes(printWriter, false, contextEnvironmentArray[n6]);
                printWriter.println("/>");
                ++n6;
            }
        }
        if ((contextLocalEjbArray = namingResources.findLocalEjbs()).length > 0) {
            n5 = 0;
            while (n5 < contextLocalEjbArray.length) {
                n4 = 0;
                while (n4 < n) {
                    printWriter.print(' ');
                    ++n4;
                }
                printWriter.print("<LocalEjb");
                this.storeAttributes(printWriter, false, contextLocalEjbArray[n5]);
                printWriter.println("/>");
                ++n5;
            }
        }
        ContextResource[] contextResourceArray = namingResources.findResources();
        n4 = 0;
        while (n4 < contextResourceArray.length) {
            int n8 = 0;
            while (n8 < n) {
                printWriter.print(' ');
                ++n8;
            }
            printWriter.print("<Resource");
            this.storeAttributes(printWriter, false, contextResourceArray[n4]);
            printWriter.println("/>");
            ++n4;
        }
        String[] stringArray = namingResources.findResourceEnvRefs();
        int n9 = 0;
        while (n9 < stringArray.length) {
            int n10 = 0;
            while (n10 < n) {
                printWriter.print(' ');
                ++n10;
            }
            printWriter.println("<ResourceEnvRef>");
            n3 = 0;
            while (n3 < n + 2) {
                printWriter.print(' ');
                ++n3;
            }
            printWriter.print("<name>");
            printWriter.print(stringArray[n9]);
            printWriter.println("</name>");
            n2 = 0;
            while (n2 < n + 2) {
                printWriter.print(' ');
                ++n2;
            }
            printWriter.print("<type>");
            printWriter.print(namingResources.findResourceEnvRef(stringArray[n9]));
            printWriter.println("</type>");
            int n11 = 0;
            while (n11 < n) {
                printWriter.print(' ');
                ++n11;
            }
            printWriter.println("</ResourceEnvRef>");
            ++n9;
        }
        ResourceParams[] resourceParamsArray = namingResources.findResourceParams();
        n3 = 0;
        while (n3 < resourceParamsArray.length) {
            n2 = 0;
            while (n2 < n) {
                printWriter.print(' ');
                ++n2;
            }
            printWriter.print("<ResourceParams");
            this.storeAttributes(printWriter, false, resourceParamsArray[n3]);
            printWriter.println(">");
            Hashtable hashtable = resourceParamsArray[n3].getParameters();
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                String string2 = (String)hashtable.get(string);
                int n12 = 0;
                while (n12 < n + 2) {
                    printWriter.print(' ');
                    ++n12;
                }
                printWriter.println("<parameter>");
                int n13 = 0;
                while (n13 < n + 4) {
                    printWriter.print(' ');
                    ++n13;
                }
                printWriter.print("<name>");
                printWriter.print(string);
                printWriter.println("</name>");
                int n14 = 0;
                while (n14 < n + 4) {
                    printWriter.print(' ');
                    ++n14;
                }
                printWriter.print("<value>");
                printWriter.print(this.convertStr(string2));
                printWriter.println("</value>");
                int n15 = 0;
                while (n15 < n + 2) {
                    printWriter.print(' ');
                    ++n15;
                }
                printWriter.println("</parameter>");
            }
            int n16 = 0;
            while (n16 < n) {
                printWriter.print(' ');
                ++n16;
            }
            printWriter.println("</ResourceParams>");
            ++n3;
        }
        ContextResourceLink[] contextResourceLinkArray = namingResources.findResourceLinks();
        int n17 = 0;
        while (n17 < contextResourceLinkArray.length) {
            int n18 = 0;
            while (n18 < n) {
                printWriter.print(' ');
                ++n18;
            }
            printWriter.print("<ResourceLink");
            this.storeAttributes(printWriter, false, contextResourceLinkArray[n17]);
            printWriter.println("/>");
            ++n17;
        }
    }

    private void storeRealm(PrintWriter printWriter, int n, Realm realm) throws Exception {
        int n2 = 0;
        while (n2 < n) {
            printWriter.print(' ');
            ++n2;
        }
        printWriter.print("<Realm");
        this.storeAttributes(printWriter, realm);
        printWriter.println("/>");
    }

    private void storeResources(PrintWriter printWriter, int n, DirContext dirContext) throws Exception {
        if (dirContext instanceof FileDirContext) {
            return;
        }
        if (dirContext instanceof ProxyDirContext) {
            return;
        }
        if (dirContext instanceof WARDirContext) {
            return;
        }
        int n2 = 0;
        while (n2 < n) {
            printWriter.print(' ');
            ++n2;
        }
        printWriter.print("<Resources");
        this.storeAttributes(printWriter, dirContext);
        printWriter.println("/>");
    }

    private void storeServer(PrintWriter printWriter, int n, Server server) throws Exception {
        int n2;
        int n3;
        LifecycleListener[] lifecycleListenerArray;
        printWriter.println("<?xml version='1.0' encoding='utf-8'?>");
        int n4 = 0;
        while (n4 < n) {
            printWriter.print(' ');
            ++n4;
        }
        printWriter.print("<Server");
        this.storeAttributes(printWriter, server);
        printWriter.println(">");
        if (server instanceof Lifecycle) {
            lifecycleListenerArray = ((Lifecycle)((Object)server)).findLifecycleListeners();
            n3 = 0;
            while (n3 < lifecycleListenerArray.length) {
                this.storeListener(printWriter, n + 2, lifecycleListenerArray[n3]);
                ++n3;
            }
        }
        if ((lifecycleListenerArray = server.getGlobalNamingResources()) != null) {
            n3 = 0;
            while (n3 < n + 2) {
                printWriter.print(' ');
                ++n3;
            }
            printWriter.println("<GlobalNamingResources>");
            this.storeNamingResources(printWriter, n + 4, (NamingResources)lifecycleListenerArray);
            n2 = 0;
            while (n2 < n + 2) {
                printWriter.print(' ');
                ++n2;
            }
            printWriter.println("</GlobalNamingResources>");
        }
        Service[] serviceArray = server.findServices();
        n2 = 0;
        while (n2 < serviceArray.length) {
            this.storeService(printWriter, n + 2, serviceArray[n2]);
            ++n2;
        }
        int n5 = 0;
        while (n5 < n) {
            printWriter.print(' ');
            ++n5;
        }
        printWriter.println("</Server>");
    }

    private void storeService(PrintWriter printWriter, int n, Service service) throws Exception {
        int n2 = 0;
        while (n2 < n) {
            printWriter.print(' ');
            ++n2;
        }
        printWriter.print("<Service");
        this.storeAttributes(printWriter, service);
        printWriter.println(">");
        Connector[] connectorArray = service.findConnectors();
        int n3 = 0;
        while (n3 < connectorArray.length) {
            this.storeConnector(printWriter, n + 2, connectorArray[n3]);
            ++n3;
        }
        Container container = service.getContainer();
        if (container != null) {
            if (container instanceof Context) {
                this.storeContext(printWriter, n + 2, (Context)container);
            } else if (container instanceof Engine) {
                this.storeEngine(printWriter, n + 2, (Engine)container);
            } else if (container instanceof Host) {
                this.storeHost(printWriter, n + 2, (Host)container);
            }
        }
        if (service instanceof Lifecycle) {
            LifecycleListener[] lifecycleListenerArray = ((Lifecycle)((Object)service)).findLifecycleListeners();
            int n4 = 0;
            while (n4 < lifecycleListenerArray.length) {
                if (!lifecycleListenerArray[n4].getClass().getName().equals(SERVER_LISTENER_CLASS_NAME)) {
                    this.storeListener(printWriter, n + 2, lifecycleListenerArray[n4]);
                }
                ++n4;
            }
        }
        int n5 = 0;
        while (n5 < n) {
            printWriter.print(' ');
            ++n5;
        }
        printWriter.println("</Service>");
    }

    private void storeStore(PrintWriter printWriter, int n, Store store) throws Exception {
        int n2 = 0;
        while (n2 < n) {
            printWriter.print(' ');
            ++n2;
        }
        printWriter.print("<Store");
        this.storeAttributes(printWriter, store);
        printWriter.println("/>");
    }

    private void storeValve(PrintWriter printWriter, int n, Valve valve) throws Exception {
        if (this.isSkippable(valve.getClass().getName())) {
            return;
        }
        int n2 = 0;
        while (n2 < n) {
            printWriter.print(' ');
            ++n2;
        }
        printWriter.print("<Valve");
        this.storeAttributes(printWriter, valve);
        printWriter.println("/>");
    }

    private boolean isSameAddress(InetAddress inetAddress, InetAddress inetAddress2) {
        byte[] byArray;
        byte[] byArray2 = inetAddress.getAddress();
        if (byArray2.length != (byArray = inetAddress2.getAddress()).length) {
            return false;
        }
        boolean bl = true;
        int n = 0;
        while (n < byArray2.length) {
            if (byArray2[n] != byArray[n]) {
                bl = false;
                break;
            }
            ++n;
        }
        if (bl) {
            return true;
        }
        int n2 = 0;
        while (n2 < byArray2.length) {
            if (byArray2[n2] != byArray[byArray2.length - 1 - n2]) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private boolean isUseNaming() {
        boolean bl = true;
        String string = System.getProperty("catalina.useNaming");
        if (string != null && string.equals("false")) {
            bl = false;
        }
        return bl;
    }

    public void addLifecycleListener(LifecycleListener lifecycleListener) {
        this.lifecycle.addLifecycleListener(lifecycleListener);
    }

    public LifecycleListener[] findLifecycleListeners() {
        return this.lifecycle.findLifecycleListeners();
    }

    public void removeLifecycleListener(LifecycleListener lifecycleListener) {
        this.lifecycle.removeLifecycleListener(lifecycleListener);
    }

    public void start() throws LifecycleException {
        if (this.started) {
            throw new LifecycleException(sm.getString("standardServer.start.started"));
        }
        this.lifecycle.fireLifecycleEvent("before_start", null);
        this.lifecycle.fireLifecycleEvent("start", null);
        this.started = true;
        Service[] serviceArray = this.services;
        synchronized (serviceArray) {
            int n = 0;
            while (n < this.services.length) {
                if (this.services[n] instanceof Lifecycle) {
                    ((Lifecycle)((Object)this.services[n])).start();
                }
                ++n;
            }
        }
        this.lifecycle.fireLifecycleEvent("after_start", null);
    }

    public void stop() throws LifecycleException {
        if (!this.started) {
            throw new LifecycleException(sm.getString("standardServer.stop.notStarted"));
        }
        this.lifecycle.fireLifecycleEvent("before_stop", null);
        this.lifecycle.fireLifecycleEvent("stop", null);
        this.started = false;
        int n = 0;
        while (n < this.services.length) {
            if (this.services[n] instanceof Lifecycle) {
                ((Lifecycle)((Object)this.services[n])).stop();
            }
            ++n;
        }
        this.lifecycle.fireLifecycleEvent("after_stop", null);
    }

    public void initialize() throws LifecycleException {
        if (this.initialized) {
            throw new LifecycleException(sm.getString("standardServer.initialize.initialized"));
        }
        this.initialized = true;
        int n = 0;
        while (n < this.services.length) {
            this.services[n].initialize();
            ++n;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

